<?php

namespace App\Actions\Fortify;

use App\Models\User;
use App\Models\ResearchTeam;
use App\Models\Task;

trait HandlesOnboardingTasks
{
    /**
     * Create onboarding tasks for a new team member based on the team's checklist.
     *
     * @param  \App\Models\User  $newUser
     * @param  \App\Models\ResearchTeam  $team
     * @return void
     */
    protected function createOnboardingTasks(User $newUser, ResearchTeam $team): void
    {
        $checklistItems = $team->onboardingChecklistItems;
        $teamManager = $team->managers()->first(); // پیدا کردن مدیر تیم

        foreach ($checklistItems as $item) {
            $task = Task::create([
                'project_id' => null, // وظیفه شخصی و غیر پروژه‌ای
                'creator_id' => $teamManager ? $teamManager->id : $newUser->id, // ایجاد کننده وظیفه
                'title' => $item->title,
                'status' => 'برای انجام',
                'priority' => 'متوسط',
            ]);

            // تخصیص وظیفه به کاربر جدید
            $task->assignees()->sync([$newUser->id]);
        }
    }
}
