<?php

namespace App\Console\Commands;

use App\Models\InventoryItem;
use App\Notifications\ExpirationDateAlert;
use Illuminate\Console\Command;

class CheckExpiringItems extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'inventory:check-expiring';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Check for inventory items that are expiring soon and notify team admins.';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Checking for expiring items...');

        // ما آیتم‌هایی را پیدا می‌کنیم که تاریخ انقضای آن‌ها در ۳۰ روز آینده است
        $warningDate = now()->addDays(30);

        $expiringItems = InventoryItem::whereNotNull('expiration_date')
            ->whereDate('expiration_date', '<=', $warningDate)
            ->whereDate('expiration_date', '>', now())
            ->with('researchTeam.users')
            ->get();

        foreach ($expiringItems as $item) {
            // ما مدیران تیمی را که این آیتم به آن تعلق دارد، پیدا می‌کنیم
            $admins = $item->researchTeam->users()->wherePivot('role', 'admin')->get();

            foreach ($admins as $admin) {
                // و برای هر کدام، یک اعلان ارسال می‌کنیم
                $admin->notify(new ExpirationDateAlert($item));
            }
        }

        $this->info('Finished checking for expiring items. ' . $expiringItems->count() . ' notifications sent.');
        return 0;
    }
}

