<?php

namespace App\Console\Commands;

use App\Models\Task;
use App\Notifications\TaskDueReminderNotification;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Notification;
use Carbon\Carbon;

class SendTaskReminders extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'tasks:send-reminders';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Send reminder notifications for tasks that are due soon.';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Searching for tasks with approaching due dates...');

        // یادآوری برای وظایفی که ۳ روز دیگر یا ۱ روز دیگر موعدشان است
        $reminderDays = [3, 1, 0];

        foreach ($reminderDays as $days) {
            $targetDate = Carbon::today()->addDays($days)->toDateString();

            // [UPDATED] ما روابط لازم را برای جلوگیری از کوئری‌های اضافه، از قبل بارگذاری می‌کنیم
            $tasks = Task::with(['assignees', 'creator', 'project.owner'])
                ->where('status', '!=', 'انجام شده')
                ->whereDate('due_date', $targetDate)
                ->get();

            if ($tasks->isNotEmpty()) {
                $this->info("Found {$tasks->count()} tasks due in {$days} day(s). Sending notifications...");

                foreach ($tasks as $task) {
                    // [NEW] جمع‌آوری تمام دریافت‌کنندگان (مسئولین، ایجادکننده و مالک طرح)
                    $recipients = collect($task->assignees);
                    $recipients->push($task->creator);
                    $recipients->push($task->project->owner);

                    // حذف موارد تکراری (مثلاً اگر مالک طرح، خودش مسئول وظیفه هم باشد)
                    $uniqueRecipients = $recipients->unique('id')->filter();

                    if ($uniqueRecipients->isNotEmpty()) {
                        Notification::send($uniqueRecipients, new TaskDueReminderNotification($task, $days));
                    }
                }
            }
    }
}
}
