<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     */
    protected function schedule(Schedule $schedule): void
    {
        // $schedule->command('inspire')->hourly();

        // ما به زمان‌بند لاراول می‌گوییم که دستور ما را هر روز اجرا کند
        $schedule->command('inventory:check-expiring')->daily();
        // اجرای دستور ارسال یادآوری‌ها، هر روز ساعت ۸ صبح
        $schedule->command('tasks:send-reminders')->dailyAt('08:00');
        // اجرای دستور ارسال یادآوری‌ها، هر روز ساعت ۸ صبح
        $schedule->command('equipment:send-reminders')->dailyAt('08:00');
        // [NEW] Run the inventory forecasting command every day at midnight.
        $schedule->command('app:forecast-inventory')->daily();
        // [NEW] Run the project risk analysis command every day at 1 AM.
        $schedule->command('app:analyze-project-risks')->dailyAt('01:00');
        $schedule->command('app:analyze-purchase-history')->weekly();
        // [NEW] Add this line to run our command daily at midnight.
        $schedule->command('benchsync:auto-confirm-deliveries')->daily();
        // [NEW] Runs daily to send reminders for shipments nearing the end of the grace period.
        $schedule->command('benchsync:send-reminders')->daily();
    }

    /**
     * Register the commands for the application.
     */
    protected function commands(): void
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
