<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AdminLoginController extends Controller
{
    /**
     * Show the admin login form.
     */
    public function showLoginForm()
    {
        return view('auth.admin-login');
    }

    /**
     * Handle a login request for the admin.
     */
    public function login(Request $request)
    {
        $credentials = $request->validate([
            'email' => ['required', 'email'],
            'password' => ['required'],
        ]);

        // ما به صورت صریح تلاش می‌کنیم تا با گارد 'admin' احراز هویت کنیم
        if (Auth::guard('admin')->attempt($credentials, $request->boolean('remember'))) {
            // We also check if the authenticated user has the 'super_admin' role
            if (!Auth::guard('admin')->user()->hasRole('super_admin')) {
                Auth::guard('admin')->logout();
                return back()->withErrors([
                    'email' => 'شما اجازه دسترسی به این بخش را ندارید.',
                ])->onlyInput('email');
            }

            $request->session()->regenerate();

            // در آینده، کاربر به داشبورد اختصاصی ادمین هدایت خواهد شد
            return redirect()->intended(route('admin.dashboard'));
        }

        return back()->withErrors([
            'email' => 'اطلاعات ورود ارائه شده با سوابق ما مطابقت ندارد.',
        ])->onlyInput('email');
    }

    /**
     * Log the admin out of the application.
     */
    public function logout(Request $request)
    {
        Auth::guard('admin')->logout();

        $request->session()->invalidate();
        $request->session()->regenerateToken();

        return redirect('/');
    }
}
