<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class SupplierLoginController extends Controller
{
    /**
     * Show the supplier login form.
     */
    public function showLoginForm()
    {
        return view('auth.supplier-login');
    }

    /**
     * Handle a login request for the supplier.
     */
    public function login(Request $request)
    {
        $credentials = $request->validate([
            'email' => ['required', 'email'],
            'password' => ['required'],
        ]);

        // ما به صورت صریح تلاش می‌کنیم تا با گارد 'supplier' احراز هویت کنیم
        if (Auth::guard('supplier')->attempt($credentials, $request->boolean('remember'))) {
            $request->session()->regenerate();

            // در آینده، کاربر به داشبورد اختصاصی خودش هدایت خواهد شد
            return redirect()->intended('/supplier/dashboard');
        }

        return back()->withErrors([
            'email' => 'اطلاعات ورود ارائه شده با سوابق ما مطابقت ندارد.',
        ])->onlyInput('email');
    }

    /**
     * Log the supplier out of the application.
     */
    public function logout(Request $request)
    {
        Auth::guard('supplier')->logout();

        $request->session()->invalidate();
        $request->session()->regenerateToken();

        return redirect('/supplier/login');
    }
}
