<?php

namespace App\Http\Controllers;

use App\Models\TeamInvitation;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\URL;
use App\Actions\Fortify\HandlesOnboardingTasks;

class InvitationController extends Controller
{
    use HandlesOnboardingTasks;
    /**
     * Accept a team invitation.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  string  $token
     * @return \Illuminate\Http\RedirectResponse
     */
    public function accept(Request $request, $token)
    {
        // 1. پیدا کردن دعوت‌نامه بر اساس توکن
        $invitation = TeamInvitation::where('token', $token)->firstOrFail();

        // 2. بررسی تاریخ انقضای دعوت‌نامه
        if ($invitation->expires_at->isPast()) {
            return redirect()->route('login')->with('status', 'این لینک دعوت‌نامه منقضی شده است.');
        }

        // 3. بررسی اینکه آیا کاربری با این ایمیل از قبل وجود دارد یا خیر
        $user = User::where('email', $invitation->email)->first();

        // سناریوی اول: کاربر از قبل در سیستم عضو است
        if ($user) {
            // اگر کاربر لاگین نکرده باشد، او را به صفحه لاگین هدایت می‌کنیم
            if (!Auth::check()) {
                return redirect()->route('login')->with('status', 'برای پذیرش دعوت‌نامه، لطفاً ابتدا وارد حساب کاربری خود شوید.');
            }
            // اگر کاربر لاگین کرده ولی ایمیل او با ایمیل دعوت‌نامه مطابقت ندارد
            if (Auth::user()->email !== $invitation->email) {
                return redirect()->route('dashboard')->with('status', 'این دعوت‌نامه برای حساب کاربری دیگری ارسال شده است.');
            }
        }
        // سناریوی دوم: کاربر جدید است
        else {
            // کاربر را به صفحه ثبت‌نام هدایت کرده و توکن و ایمیل را در session ذخیره می‌کنیم
            return redirect()->route('register', [
                'email' => $invitation->email,
                'invitation_token' => $invitation->token,
            ]);
        }

        // 4. افزودن کاربر به تیم
        $invitation->team->users()->attach(Auth::user(), ['role' => $invitation->role]);

        $this->createOnboardingTasks(Auth::user(), $invitation->team);

        // 5. حذف دعوت‌نامه پس از استفاده
        $invitation->delete();

        return redirect()->route('research-teams.dashboard')->with('status', 'شما با موفقیت به تیم ' . $invitation->team->name . ' اضافه شدید!');
    }
}
