<?php

namespace App\Http\Controllers;

use App\Models\Project;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use Carbon\Carbon;

class ProjectReportController extends Controller
{
    /**
     * Display the specified project report.
     *
     * @param  \App\Models\Project  $project
     * @return \Illuminate\View\View
     */
    public function show(Project $project)
    {
        // ابتدا بررسی می‌کنیم که آیا کاربر فعلی اجازه مشاهده این طرح را دارد یا خیر
        Gate::authorize('view', $project);

        // بارگذاری تمام روابط لازم برای نمایش در گزارش
        $project->load([
            'owner',
            'researchTeam.institution',
            'tasks.assignees',
            'collaborators',
            'budgetItems',
            'labNotebookEntries' => function ($query) {
                // مرتب‌سازی یادداشت‌ها بر اساس تاریخ ثبت
                $query->orderBy('entry_date', 'desc');
            },
            'labNotebookEntries.user', // نویسنده یادداشت
            'labNotebookEntries.materials', // مواد مصرفی
            'labNotebookEntries.signatures.user', // امضا کنندگان
            'labNotebookEntries.versions', // تاریخچه نسخه‌ها
        ]);

        // محاسبه آمار وظایف
        $tasks = $project->tasks;
        $totalTasks = $tasks->count();
        $chartData = [];
        $overdueTasks = collect();

        if ($totalTasks > 0) {
            $completedTasks = $tasks->where('status', 'انجام شده')->count();
            $inProgressTasks = $tasks->where('status', 'در حال انجام')->count();
            $todoTasks = $tasks->where('status', 'برای انجام')->count();

            // پیدا کردن وظایف عقب افتاده
            $overdueTasks = $tasks->where('status', '!=', 'انجام شده')
                ->where('due_date', '<', Carbon::today());

            // آماده‌سازی داده‌ها برای نمودار دایره‌ای
            $chartData = [
                'labels' => ['انجام شده', 'در حال انجام', 'برای انجام'],
                'data' => [$completedTasks, $inProgressTasks, $todoTasks],
            ];
        }

        // ارسال تمام داده‌ها به view اختصاصی گزارش
        return view('reports.project', [
            'project' => $project,
            'tasks' => $tasks,
            'overdueTasks' => $overdueTasks,
            'chartData' => $chartData,
        ]);
    }
}
