<?php

namespace App\Http\Controllers;

use App\Models\Equipment;
use Illuminate\Http\Request;

class PublicEquipmentController extends Controller
{
    /**
     * Display the publicly accessible details and calibration history of a piece of equipment.
     *
     * @param  \App\Models\Equipment  $equipment
     * @return \Illuminate\View\View
     */
    public function show(Equipment $equipment)
    {
        // بارگذاری تمام روابط لازم برای نمایش در صفحه عمومی
        $equipment->load([
            'researchTeam',
            'responsibleUser',
            'calibrationLogs' => function ($query) {
                $query->orderBy('calibration_date', 'desc');
            },
            'calibrationLogs.user',
            'calibrationLogs.attachments'
        ]);

        // ارسال داده‌ها به view اختصاصی
        return view('public.equipment-details', [
            'equipment' => $equipment,
        ]);
    }
}
