<?php

namespace App\Http\Controllers;

use App\Models\ResearchTeam;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;

class TeamWorkloadReportController extends Controller
{
    public function show(ResearchTeam $team)
    {
        // Gate::authorize('view', $team); // You should create a policy for this

        $team->load('users', 'projects.tasks.assignees');

        $workload = [];
        $members = $team->users;
        $projectIds = $team->projects->pluck('id');

        foreach ($members as $member) {
            $taskCount = $member->assignedTasks()->whereIn('project_id', $projectIds)->count();
            $workload[$member->name] = $taskCount;
        }

        $chartData = [
            'labels' => array_keys($workload),
            'datasets' => [
                [
                    'label' => 'تعداد وظایف محول شده',
                    'data' => array_values($workload),
                    'backgroundColor' => '#4f46e5',
                ]
            ],
        ];

        return view('reports.team-workload', [
            'team' => $team,
            'chartData' => $chartData,
        ]);
    }
}
