<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB; // <--- استفاده مستقیم از فاساد DB
use Symfony\Component\HttpFoundation\Response;

class CheckSystemRole
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function handle(Request $request, Closure $next, ...$requiredRoles): Response
    {
        if (!Auth::check()) {
            return redirect('login');
        }

        $userId = Auth::id();

        // کوئری مستقیم به پایگاه داده برای بررسی نقش کاربر
        // این روش هرگونه مشکل مربوط به روابط Eloquent را دور می‌زند
        $hasAccess = DB::table('role_user')
            ->join('roles', 'role_user.role_id', '=', 'roles.id')
            ->where('role_user.user_id', $userId)
            ->whereIn('roles.name', $requiredRoles)
            ->exists(); // بررسی می‌کند که آیا حداقل یک ردیف با این شرایط وجود دارد یا خیر

        if ($hasAccess) {
            // اگر دسترسی داشت، اجازه عبور می‌دهیم
            return $next($request);
        }

        // در غیر این صورت، دسترسی را مسدود می‌کنیم
        abort(403, 'This action is unauthorized.');
    }
}
