<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Project;
use Symfony\Component\HttpFoundation\Response;

class CheckWarehouseAccess
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = Auth::user();

        // اگر کاربر لاگین نکرده باشد یا نقش super_admin داشته باشد
        if (!$user) {
            return redirect('login');
        }
        if ($user->hasRole('super_admin')) {
            return $next($request);
        }

        // 1. دریافت ID طرح‌هایی که کاربر مالک آن‌هاست یا مسئول انبار آن‌ها
        $managedProjectIds = Project::where('owner_id', $user->id)
            ->orWhere('warehouse_manager_id', $user->id)
            ->pluck('id');

        // 2. دریافت ID طرح‌هایی که کاربر در آن‌ها دسترسی مستقیم مدیریت انبار را دارد
        $projectIdsWithDirectPermission = $user->projectPermissions()
            ->where('name', 'warehouse-manage-requests')
            ->get()
            ->pluck('pivot.project_id');

        // 3. ادغام لیست IDها
        $allManagedProjectIds = $managedProjectIds->merge($projectIdsWithDirectPermission)->unique();

//        // اگر کاربر هیچ طرحی را برای مدیریت انبار در اختیار ندارد، دسترسی را رد کن
        if ($allManagedProjectIds->isEmpty()) {
            abort(403, 'شما دسترسی لازم برای مشاهده این صفحه را ندارید.');
        }

        return $next($request);
    }
}
