<?php

namespace App\Http\Middleware;

use App\Policies\FinancialPolicy;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class EnsureCanViewFinancials
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = Auth::user();
        $policy = new FinancialPolicy();

        if (!$user) {
            return redirect('login');
        }

        // Manually check if the user is authorized by the policy.
        if ($user && $policy->viewAny($user)) {
            return $next($request);
        }

        // If not authorized, abort with a 403 error.
        abort(403, 'شما دسترسی لازم برای صفحه را ندارید.');
    }
}
