<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class EnsureUserHasInstitution
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {

        // We check if the authenticated user has any approved memberships.
        if ($request->user() && !$request->user()->institutionMemberships()->where('status', 'approved')->exists()) {
            // If not, redirect them to the onboarding page.
            return redirect()->route('onboarding');
        }

        return $next($request);
    }
}

