<?php
//
//namespace App\Livewire\Admin;
//
//use App\Models\Role;
//use App\Models\User;
//use App\models\Institution;
//use Livewire\Component;
//use Livewire\WithPagination;
//
//class UserManager extends Component
//{
//    public string $search = '';
//    // Properties for Role Management Modal
//    public ?User $editingUser = null;
//    public $confirmingRoleEdit = false;
//    public $allRoles = [];
//    public $userRoles = [];
//    public $roleFilter = '';
//    public $institutionFilter = '';
//    // Properties for Create/Edit Modal
//    public $confirmingUserAction = false;
//    public array $state = [];
//    // Properties for Delete Modal
//    public $userIdToDelete;
//    public $confirmingUserDeletion = false;
//
//    /**
//     * Show the modal for editing a user's roles.
//     */
//    public function confirmRoleEdit(User $user)
//    {
//        $this->resetErrorBag();
//        $this->editingUser = $user;
//
//        // ما تمام نقش‌های سیستمی را برای نمایش در فرم، بارگذاری می‌کنیم
////        $this->allRoles = Role::all();
//          $this->allRoles = Role::select('id', 'name')->get();
//
//        // ما شناسه‌های نقش‌های فعلی کاربر را برای پر کردن چک‌باکس‌ها، استخراج می‌کنیم
////        $this->userRoles = $user->systemRoles()->pluck('id')->map(fn($id) => (string) $id)->toArray();
//        $this->userRoles = $user->systemRoles()->pluck('roles.id')->map(fn($id) => (string) $id)->toArray();
//
//        $this->confirmingRoleEdit = true;
//    }
//
//
//    protected function rules()
//    {
//        return [
//            'state.first_name' => 'required|string|max:255',
//            'state.last_name' => 'required|string|max:255',
//            'state.username' => 'required|string|max:255|unique:users,username,' . ($this->editingUser?->id ?? ''),
//            'state.email' => 'required|email|max:255|unique:users,email,' . ($this->editingUser?->id ?? ''),
//            'state.password' => 'nullable|string|min:8|confirmed',
//            'userRoles' => 'array',
//        ];
//    }
//
//    public function confirmUserAction(?User $user = null)
//    {
//        $this->resetErrorBag();
//        if ($user && $user->exists) {
//            $this->editingUser = $user;
//            $this->state = $user->toArray();
////            $this->userRoles = $user->systemRoles()->pluck('id')->map(fn($id) => (string) $id)->toArray();
//            $this->userRoles = $user->systemRoles()->pluck('roles.id')->map(fn($id) => (string) $id)->toArray();
//
//        } else {
//            $this->editingUser = null;
//            $this->state = [];
//            $this->userRoles = [];
//        }
//        $this->allRoles = Role::all();
//        $this->confirmingUserAction = true;
//    }
//
//    public function saveUser()
//    {
//        $this->validate();
//
//        $userData = $this->state;
//        if (!empty($userData['password'])) {
//            $userData['password'] = Hash::make($userData['password']);
//        } else {
//            unset($userData['password']);
//        }
//
//        if ($this->editingUser) {
//            // Update User
//            $this->editingUser->update($userData);
//            $this->editingUser->systemRoles()->sync($this->userRoles);
//            session()->flash('message', 'کاربر با موفقیت به‌روزرسانی شد.');
//        } else {
//            // Create User
//            $user = User::create($userData);
//            $user->systemRoles()->sync($this->userRoles);
//            session()->flash('message', 'کاربر جدید با موفقیت ایجاد شد.');
//        }
//
//        $this->confirmingUserAction = false;
//    }
//
//    public function confirmUserDeletion($id)
//    {
//        $this->userIdToDelete = $id;
//        $this->confirmingUserDeletion = true;
//    }
//
//    public function deleteUser()
//    {
//        User::findOrFail($this->userIdToDelete)->delete();
//        $this->confirmingUserDeletion = false;
//        session()->flash('message', 'کاربر با موفقیت حذف شد.');
//    }
//
//
//    /**
//     * Update the user's roles.
//     */
//    public function updateRoles()
//    {
//        if (!$this->editingUser) {
//            return;
//        }
//
//        // The sync method handles attaching and detaching roles.
//        $this->editingUser->systemRoles()->sync($this->userRoles);
//
//        $this->confirmingRoleEdit = false;
//        session()->flash('message', 'نقش‌های کاربر با موفقیت به‌روزرسانی شد.');
//    }
//
//    // این متد برای جلوگیری از ریست شدن صفحه‌بندی هنگام جستجو استفاده می‌شود
//    public function updatingSearch()
//    {
//        $this->resetPage();
//    }
//
//    public function render()
//    {
//        $usersQuery = User::with(['systemRoles', 'institutionMemberships.institution']);
//
//        if (!empty($this->search)) {
//            $usersQuery->where(function ($query) {
//                $query->where('first_name', 'like', '%' . $this->search . '%')
//                    ->orWhere('last_name', 'like', '%' . $this->search . '%')
//                    ->orWhere('username', 'like', '%' . $this->search . '%')
//                    ->orWhere('email', 'like', '%' . $this->search . '%');
//            });
//        }
//        // فیلتر بر اساس نقش سیستمی
//        if (!empty($this->roleFilter)) {
//            $usersQuery->whereHas('systemRoles', function ($query) {
//                $query->where('role_id', $this->roleFilter);
//            });
//        }
//
//        // فیلتر بر اساس سازمان
//        if (!empty($this->institutionFilter)) {
//            $usersQuery->whereHas('institutionMemberships', function ($query) {
//                $query->where('institution_id', $this->institutionFilter);
//            });
//        }
//
//        $roles = Role::all();
//        $institutions = Institution::all();
//        $users = $usersQuery->latest()->paginate(10); // برای مدیریت بهتر، از صفحه‌بندی استفاده می‌کنیم
//
//        return view('livewire.admin.user-manager', [
//            'users' => $users,
//            'roles' => $roles,
//            'institutions' => $institutions,
//        ])->layout('layouts.admin');
//    }
//}


namespace App\Livewire\Admin;

use App\Models\User;
use App\Models\Institution;
use Illuminate\Support\Facades\Hash;
use Livewire\Component;
use Livewire\WithPagination;
use Spatie\Permission\Models\Role;

// [UPDATED] استفاده از مدل Role پکیج Spatie

class UserManager extends Component
{
    use WithPagination;

    // [NOTE] اضافه کردن این Trait برای سازگاری با کد شما

    public string $search = '';
    // Properties for Role Management Modal
    public ?User $editingUser = null;
    public $confirmingRoleEdit = false;
    public $allRoles = [];
    public array $userRoles = []; // [UPDATED] اطمینان از اینکه این پراپرتی همیشه آرایه است
    public $roleFilter = '';
    public $institutionFilter = '';
    // Properties for Create/Edit Modal
    public $confirmingUserAction = false;
    public array $state = [];
    // Properties for Delete Modal
    public $userIdToDelete;
    public $confirmingUserDeletion = false;

    /**
     * [UPDATED] Show the modal for editing a user's roles using Spatie.
     */
    public function confirmRoleEdit(User $user)
    {
        $this->resetErrorBag();
        $this->editingUser = $user;
        $this->allRoles = Role::all();
        // استفاده از رابطه 'roles' که توسط Spatie فراهم شده است
        $this->userRoles = $this->editingUser->roles->pluck('id')->map(fn($id) => (string)$id)->toArray();
        $this->confirmingRoleEdit = true;
    }

    protected function rules()
    {
        // ... (قوانین اعتبارسنجی بدون تغییر باقی می‌مانند)
        return [
            'state.first_name' => 'required|string|max:255',
            'state.last_name' => 'required|string|max:255',
            'state.username' => 'required|string|max:255|unique:users,username,' . ($this->editingUser?->id ?? ''),
            'state.email' => 'required|email|max:255|unique:users,email,' . ($this->editingUser?->id ?? ''),
            'state.password' => 'nullable|string|min:8|confirmed',
            'userRoles' => 'array',
        ];
    }

    /**
     * [UPDATED] Show the modal for creating/editing a user.
     */
    public function confirmUserAction(?User $user = null)
    {
        $this->resetErrorBag();
        if ($user && $user->exists) {
            $this->editingUser = $user;
            $this->state = $user->toArray();
            // استفاده از رابطه 'roles'
            $this->userRoles = $user->roles->pluck('id')->map(fn($id) => (string)$id)->toArray();
        } else {
            $this->editingUser = null;
            $this->state = [];
            $this->userRoles = [];
        }
        $this->allRoles = Role::all();
        $this->confirmingUserAction = true;
    }

    /**
     * [UPDATED] Save or update a user and sync their roles using Spatie.
     */
    public function saveUser()
    {
        $this->validate();

        $userData = $this->state;
        if (!empty($userData['password'])) {
            $userData['password'] = Hash::make($userData['password']);
        } else {
            unset($userData['password']);
        }

        if ($this->editingUser) {
            // Update User
            $this->editingUser->update($userData);
            // استفاده از متد syncRoles پکیج Spatie
            $this->editingUser->syncRoles($this->userRoles);
            session()->flash('message', 'کاربر با موفقیت به‌روزرسانی شد.');
        } else {
            // Create User
            $user = User::create($userData);
            // استفاده از متد syncRoles پکیج Spatie
            $user->syncRoles($this->userRoles);
            session()->flash('message', 'کاربر جدید با موفقیت ایجاد شد.');
        }

        $this->confirmingUserAction = false;
    }

    public function confirmUserDeletion($id)
    {
        $this->userIdToDelete = $id;
        $this->confirmingUserDeletion = true;
    }

    public function deleteUser()
    {
        User::findOrFail($this->userIdToDelete)->delete();
        $this->confirmingUserDeletion = false;
        session()->flash('message', 'کاربر با موفقیت حذف شد.');
    }

    /**
     * [UPDATED] Update the user's roles using Spatie's syncRoles method.
     */
    public function updateRoles()
    {
        if (!$this->editingUser) {
            return;
        }
        // استفاده از متد syncRoles پکیج Spatie
        $this->editingUser->syncRoles($this->userRoles);
        $this->confirmingRoleEdit = false;
        session()->flash('message', 'نقش‌های کاربر با موفقیت به‌روزرسانی شد.');
    }

    public function updatingSearch()
    {
        $this->resetPage();
    }

    /**
     * [UPDATED] Render the component with queries adapted for Spatie.
     */
    public function render()
    {
        // استفاده از رابطه 'roles' به جای 'systemRoles'
        $usersQuery = User::with(['roles', 'institutionMemberships.institution']);

        if (!empty($this->search)) {
            $usersQuery->where(function ($query) {
                $query->where('first_name', 'like', '%' . $this->search . '%')
                    ->orWhere('last_name', 'like', '%' . $this->search . '%')
                    ->orWhere('username', 'like', '%' . $this->search . '%')
                    ->orWhere('email', 'like', '%' . $this->search . '%');
            });
        }
        // فیلتر بر اساس نقش با استفاده از رابطه 'roles'
        if (!empty($this->roleFilter)) {
            $usersQuery->whereHas('roles', function ($query) {
                $query->where('id', $this->roleFilter);
            });
        }

        // فیلتر بر اساس سازمان (بدون تغییر)
        if (!empty($this->institutionFilter)) {
            $usersQuery->whereHas('institutionMemberships', function ($query) {
                $query->where('institution_id', $this->institutionFilter);
            });
        }

        $roles = Role::all();
        $institutions = Institution::all();
        $users = $usersQuery->latest()->paginate(10);

        return view('livewire.admin.user-manager', [
            'users' => $users,
            'roles' => $roles,
            'institutions' => $institutions,
        ])->layout('layouts.admin');
    }
}
