<?php

namespace App\Livewire;

use App\Models\Equipment;
use Illuminate\Support\Facades\Storage;
use Livewire\Component;

class CalibrationHistoryModal extends Component
{
    public ?Equipment $equipment = null;
    public bool $showingModal = false;

    protected $listeners = ['showCalibrationHistory'];

    public function showCalibrationHistory($equipmentId)
    {
        $this->equipment = Equipment::with(['calibrationLogs.user', 'calibrationLogs.attachments'])->find($equipmentId);
        $this->showingModal = true;
    }

    public function downloadAttachment($attachmentId)
    {
        $attachment = \App\Models\CalibrationLogAttachment::findOrFail($attachmentId);
        // در اینجا می‌توانید یک Policy برای کنترل دسترسی به دانلود فایل اضافه کنید
        return Storage::disk('public')->download($attachment->file_path, $attachment->file_name);
    }

    public function render()
    {
        return view('livewire.calibration-history-modal');
    }
}
