<?php

namespace App\Livewire;

use App\Models\User;
use App\Models\Equipment;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Livewire\Component;

class CalibrationManagerAssigner extends Component
{
    public $teamMembers;
    public $selectedManagerId;
    public bool $isTeamManager = false; // برای کنترل نمایش کامپوننت

    public function mount()
    {
        $manager = Auth::user();

        // بررسی می‌کنیم که آیا کاربر فعلی، مدیر حداقل یک تیم است یا خیر
        $this->isTeamManager = $manager->researchTeams()->wherePivot('role', 'admin')->exists();

        if ($this->isTeamManager) {
            // واکشی تمام کاربران از تمام تیم‌های تحت مدیریت کاربر فعلی
            $allMembers = $manager->researchTeams()->with('users')->get()
                ->pluck('users')->flatten()->unique('id');

            // حذف خود مدیر از لیست انتخاب
            $this->teamMembers = $allMembers->where('id', '!=', $manager->id);

            // تنظیم مقدار اولیه برای لیست کشویی
            $this->selectedManagerId = $manager->calibration_manager_id;
        }
    }

    public function assignManager()
    {
        // بررسی مجدد دسترسی قبل از انجام عملیات
        if (!$this->isTeamManager) {
            abort(403, 'شما اجازه انجام این کار را ندارید.');
        }

        $manager = Auth::user();

        $this->validate([
            'selectedManagerId' => 'nullable|exists:users,id',
        ]);

        // اطمینان از اینکه کاربر انتخاب شده، عضو یکی از تیم‌های مدیر است
        if ($this->selectedManagerId && !$this->teamMembers->contains('id', $this->selectedManagerId)) {
            session()->flash('error', 'کاربر انتخاب شده عضو تیم شما نیست.');
            return;
        }

        $newManagerId = $this->selectedManagerId ?: null;

        DB::transaction(function () use ($manager, $newManagerId) {
            // ۱. به‌روزرسانی رکورد مدیر
            $manager->update(['calibration_manager_id' => $newManagerId]);

            // ۲. به‌روزرسانی کاربر مسئول برای تمام تجهیزات تحت مدیریت این مدیر
            Equipment::where('manager_id', $manager->id)
                ->update(['responsible_user_id' => $newManagerId]);
        });

        session()->flash('message', 'مسئول کالیبراسیون با موفقیت تعیین شد.');
    }

    public function render()
    {
        return view('livewire.calibration-manager-assigner');
    }
}
