<?php

namespace App\Livewire;

use App\Models\Equipment;
use App\Models\ResearchTeam;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;
use Carbon\Carbon;

class CalibrationStatusWidget extends Component
{
    public int $calibratedCount = 0;
    public int $dueSoonCount = 0;
    public int $overdueCount = 0;

    public function mount()
    {
        $this->calculateStats();
    }

    public function calculateStats()
    {
        $user = Auth::user();

        // دریافت ID تمام تیم‌هایی که کاربر به تجهیزات آن‌ها دسترسی دارد
        $managedTeamIds = $user->researchTeams()->wherePivot('role', 'admin')->pluck('research_teams.id');
        $calibrationManagedTeamIds = ResearchTeam::where('calibration_manager_id', $user->id)->pluck('id');
        $allVisibleTeamIds = $managedTeamIds->merge($calibrationManagedTeamIds)->unique();

        // کوئری پایه برای تجهیزاتی که کاربر می‌تواند ببیند
        $equipmentQuery = Equipment::whereIn('research_team_id', $allVisibleTeamIds)
            ->orWhere(function ($query) use ($user) {
                // افزودن تجهیزات مستقل که توسط مدیر ثبت شده‌اند
                $query->whereNull('research_team_id')->where('manager_id', $user->id);
            });

        $today = Carbon::today();
        $warningDate = $today->copy()->addDays(30); // بازه هشدار ۳۰ روزه

        $allEquipment = $equipmentQuery->get();

        // محاسبه آمار
        $this->overdueCount = $allEquipment->whereNotNull('next_calibration_date')->where('next_calibration_date', '<', $today)->count();
        $this->dueSoonCount = $allEquipment->whereNotNull('next_calibration_date')->whereBetween('next_calibration_date', [$today, $warningDate])->count();
        $this->calibratedCount = $allEquipment->where('next_calibration_date', '>', $warningDate)->count();
    }

    public function render()
    {
        return view('livewire.calibration-status-widget');
    }
}
