<?php

namespace App\Livewire;

use App\Models\FinancialAlert;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;

class FinancialAlertsWidget extends Component
{
    public function acknowledgeAlert(FinancialAlert $alert)
    {
        // Add authorization check if needed
        $alert->update([
            'is_acknowledged' => true,
            'acknowledged_by' => Auth::id(),
            'acknowledged_at' => now(),
        ]);
    }

    public function render()
    {
        $user = Auth::user();
        $teamIds = $user->researchTeams()->wherePivot('role', 'admin')->pluck('research_teams.id');

        $alerts = collect();
        if ($user->hasRole('purchasing_manager')) {
            // Purchasing manager sees all unacknowledged alerts
            $alerts = FinancialAlert::where('is_acknowledged', false)->latest()->get();
        } elseif ($teamIds->isNotEmpty()) {
            // Team managers see alerts for their teams
            $alerts = FinancialAlert::whereIn('research_team_id', $teamIds)
                ->where('is_acknowledged', false)
                ->latest()
                ->get();
        }

        return view('livewire.financial-alerts-widget', [
            'alerts' => $alerts
        ]);
    }
}
