<?php

namespace App\Livewire;

use Livewire\Component;
use Livewire\WithFileUploads;
use Maatwebsite\Excel\Facades\Excel;

class InstrumentDataImporter extends Component
{
    use WithFileUploads;

    public bool $showModal = false;
    public $dataFile;

    protected $listeners = ['openDataImporterModal'];

    public function openDataImporterModal()
    {
        $this->reset('dataFile');
        $this->resetErrorBag();
        $this->showModal = true;
    }

    public function importData()
    {
        $this->validate([
            'dataFile' => 'required|file|mimes:csv,xls,xlsx|max:5120', // 5MB Max
        ]);

        try {
            // Read the data from the uploaded file
            $data = Excel::toArray(new \stdClass(), $this->dataFile)[0];

            if (empty($data)) {
                $this->addError('dataFile', 'فایل انتخاب شده خالی است یا فرمت معتبری ندارد.');
                return;
            }

            // Build an HTML table from the data
            $html = '<table style="width: 100%; border-collapse: collapse; border: 1px solid #ccc;">';

            // Header row
            $html .= '<thead><tr style="background-color: #f2f2f2;">';
            foreach ($data[0] as $header) {
                $html .= '<th style="border: 1px solid #ccc; padding: 8px; text-align: center;">' . htmlspecialchars($header) . '</th>';
            }
            $html .= '</tr></thead>';

            // Data rows
            $html .= '<tbody>';
            foreach (array_slice($data, 1) as $row) {
                $html .= '<tr>';
                foreach ($row as $cell) {
                    $html .= '<td style="border: 1px solid #ccc; padding: 8px;">' . htmlspecialchars($cell) . '</td>';
                }
                $html .= '</tr>';
            }
            $html .= '</tbody></table>';

            // Dispatch an event to the editor component to insert the HTML
            $this->dispatch('insert-html-in-editor', html: $html);
            $this->showModal = false;

        } catch (\Exception $e) {
            $this->addError('dataFile', 'خطا در پردازش فایل: ' . $e->getMessage());
        }
    }

    public function render()
    {
        return view('livewire.instrument-data-importer');
    }
}
