<?php

namespace App\Livewire;

use App\Models\InventoryItem;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;

class InventoryForecastWidget extends Component
{
    public function render()
    {
        $user = Auth::user();
        // Get all teams the user is a member of
        $teamIds = $user->researchTeams()->pluck('research_teams.id');

        // Find items that are predicted to stock out in the next 30 days
        // and belong to the user's teams.
        $forecastedItems = InventoryItem::whereIn('research_team_id', $teamIds)
            ->whereNotNull('predicted_stockout_date')
            ->where('predicted_stockout_date', '<=', Carbon::now()->addDays(30))
            ->orderBy('predicted_stockout_date', 'asc')
            ->take(5) // Show top 5 most urgent items
            ->get();

        return view('livewire.inventory-forecast-widget', [
            'forecastedItems' => $forecastedItems
        ]);
    }
}
