<?php

namespace App\Livewire;

use Livewire\Component;

class LabNotebookChartModal extends Component
{
    public bool $showModal = false;

    // Form properties
    public string $chartType = 'bar';
    public string $chartTitle = '';
    public string $labels = ''; // Comma-separated
    public array $datasets = [];

    protected $listeners = ['openChartModal'];

    public function mount()
    {
        $this->resetForm();
    }

    public function openChartModal()
    {
        $this->resetForm();
        $this->showModal = true;
    }

    public function addDataset()
    {
        $this->datasets[] = [
            'label' => 'مجموعه داده ' . (count($this->datasets) + 1),
            'data' => '', // Comma-separated
            'backgroundColor' => sprintf('#%06X', mt_rand(0, 0xFFFFFF)),
        ];
    }

    public function removeDataset($index)
    {
        unset($this->datasets[$index]);
        $this->datasets = array_values($this->datasets);
    }

    public function generateChart()
    {
        $validated = $this->validate([
            'chartType' => 'required|in:bar,line,pie',
            'chartTitle' => 'required|string|max:255',
            'labels' => 'required|string',
            'datasets' => 'required|array|min:1',
            'datasets.*.label' => 'required|string',
            'datasets.*.data' => 'required|string',
            'datasets.*.backgroundColor' => 'required|string',
        ]);

        // We send the validated data to the frontend to be rendered by Chart.js
        $this->dispatch('render-chart', data: $validated);
    }

    private function resetForm()
    {
        $this->reset(['chartType', 'chartTitle', 'labels', 'datasets']);
        $this->chartType = 'bar';
        $this->addDataset();
    }

    public function render()
    {
        return view('livewire.lab-notebook-chart-modal');
    }
}
