<?php

namespace App\Livewire;

use App\Models\Project;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;

class MyTaskStats extends Component
{
    public Project $project;

    public int $totalTasks = 0;
    public int $completedTasks = 0;
    public int $inProgressTasks = 0;
    public int $completionPercentage = 0; // [NEW]

    public function mount(Project $project)
    {
        $this->project = $project;
        $this->calculateMyStats();
    }

    /**
     * [UPDATED] Calculate stats including completion percentage.
     */
    public function calculateMyStats()
    {
        $user = Auth::user();

        $tasks = $user->assignedTasks()
            ->where('project_id', $this->project->id)
            ->get();

        $this->totalTasks = $tasks->count();
        if ($this->totalTasks > 0) {
            $this->completedTasks = $tasks->where('status', 'انجام شده')->count();
            $this->inProgressTasks = $tasks->where('status', 'در حال انجام')->count();

            // [NEW] محاسبه درصد پیشرفت
            $this->completionPercentage = round(($this->completedTasks / $this->totalTasks) * 100);
        } else {
            $this->completionPercentage = 0;
        }
    }

    public function render()
    {
        return view('livewire.my-task-stats');
    }
}
