<?php

namespace App\Livewire;

use Illuminate\Support\Facades\Auth;
use Livewire\Component;

class MyTasksWidget extends Component
{
    public $personalTasks;

    public function mount()
    {
        $this->loadTasks();
    }

    public function loadTasks()
    {
        $user = Auth::user();

        // واکشی تمام وظایفی که به کاربر فعلی محول شده و به هیچ پروژه‌ای وابسته نیستند
        $this->personalTasks = $user->assignedTasks()
            ->whereNull('project_id')
            ->where('status', '!=', 'انجام شده')
            ->latest()
            ->get();
    }

    public function render()
    {
        return view('livewire.my-tasks-widget');
    }
}
