<?php

namespace App\Livewire;

use Illuminate\Support\Facades\Auth;
use Livewire\Component;

class NotificationCenter extends Component
{
    public $notifications;
    public $unreadCount = 0;

    public function mount()
    {
        $this->loadNotifications();
    }

    public function loadNotifications()
    {
        if (Auth::check()) {
            $user = Auth::user();
            $this->notifications = $user->unreadNotifications()->get();
            $this->unreadCount = $this->notifications->count();
        }
    }

//    public function markAsRead($notificationId)
//    {
//        $notification = Auth::user()->notifications()->find($notificationId);
//        if ($notification) {
//            $notification->markAsRead();
//        }
//        $this->loadNotifications(); // Refresh the list
//    }

    public function markAllAsRead()
    {
        Auth::user()->unreadNotifications->markAsRead();
        $this->loadNotifications(); // Refresh the list
    }

    public function render()
    {
        return view('livewire.notification-center');
    }

    /**
     * [UPDATED] Marks a notification as read and redirects the user to its associated URL.
     *
     * @param string $notificationId The ID of the notification.
     * @return \Illuminate\Http\RedirectResponse|void
     */
    public function goToNotification(string $notificationId)
    {
        $notification = Auth::user()->notifications()->find($notificationId);
        if ($notification) {
            $notification->markAsRead();

            // Redirect to the URL stored in the notification data
            if (isset($notification->data['url'])) {
                return redirect($notification->data['url']);
            }
        }
        $this->loadNotifications(); // Refresh the list if no redirect happens
    }
}

