<?php
//
//namespace App\Livewire;
//
//use App\Models\PersonalNote;
//use App\Models\PersonalNoteAttachment;
//use Illuminate\Support\Facades\Auth;
//use Illuminate\Support\Facades\Storage;
//use Livewire\Component;
//use Livewire\WithFileUploads;
//use Livewire\WithPagination;
//
//class PersonalNotebook extends Component
//{
//    use WithFileUploads;
//    use WithPagination;
//
//    public bool $confirmingNoteAction = false;
//    public ?PersonalNote $editingNote = null;
//    public array $state = [];
//    public $attachment;
//
//    public ?PersonalNote $noteToDelete = null;
//    public bool $confirmingNoteDeletion = false;
//
//    protected function rules()
//    {
//        return [
//            'state.title' => 'required|string|max:255',
//            'state.body' => 'nullable|string',
//            'attachment' => 'nullable|file|max:10240', // 10MB Max
//        ];
//    }
//
//    public function confirmNoteAction(?PersonalNote $note = null)
//    {
//        $this->resetErrorBag();
//        if ($note && $note->exists) {
//            $this->editingNote = $note->load('attachments');
//            $this->state = $note->toArray();
//        } else {
//            $this->editingNote = null;
//            $this->state = [];
//        }
//        $this->confirmingNoteAction = true;
//        $this->dispatch('init-editor', content: $this->state['body'] ?? '');
//    }
//
//    private function generateNoteCode(): string
//    {
//        $user = Auth::user();
//        $usernamePrefix = strtoupper($user->username);
//
//        $latestNote = PersonalNote::where('user_id', $user->id)->latest('id')->first();
//        $nextId = $latestNote ? (int)substr($latestNote->note_code, -6) + 1 : 1;
//
//        do {
//            $noteCode = $usernamePrefix . '-' . str_pad($nextId, 6, '0', STR_PAD_LEFT);
//            $nextId++;
//        } while (PersonalNote::where('note_code', $noteCode)->exists());
//
//        return $noteCode;
//    }
//
//    public function saveNote()
//    {
//        $validatedData = $this->validate();
//
//        if ($this->editingNote) {
//            $this->editingNote->update($validatedData['state']);
//            session()->flash('message', 'یادداشت با موفقیت به‌روزرسانی شد.');
//        } else {
//            $noteData = $validatedData['state'];
//            $noteData['user_id'] = Auth::id();
//            $noteData['note_code'] = $this->generateNoteCode();
//            $this->editingNote = PersonalNote::create($noteData);
//            session()->flash('message', 'یادداشت جدید با موفقیت ایجاد شد.');
//        }
//
//        if ($this->attachment) {
//            $path = $this->attachment->store('personal_notes/' . $this->editingNote->id, 'public');
//            $this->editingNote->attachments()->create([
//                'user_id' => Auth::id(),
//                'file_path' => $path,
//                'file_name' => $this->attachment->getClientOriginalName(),
//                'file_size' => $this->attachment->getSize(),
//                'mime_type' => $this->attachment->getMimeType(),
//            ]);
//        }
//
//        $this->confirmingNoteAction = false;
//        $this->reset('attachment');
//    }
//
//    public function removeAttachment(PersonalNoteAttachment $attachment)
//    {
//        Storage::disk('public')->delete($attachment->file_path);
//        $attachment->delete();
//        $this->editingNote->load('attachments'); // Refresh attachments
//    }
//
//    public function confirmNoteDeletion(PersonalNote $note)
//    {
//        $this->noteToDelete = $note;
//        $this->confirmingNoteDeletion = true;
//    }
//
//    public function deleteNote()
//    {
//        if ($this->noteToDelete) {
//            // Delete all associated files from storage first
//            foreach ($this->noteToDelete->attachments as $attachment) {
//                Storage::disk('public')->delete($attachment->file_path);
//            }
//            $this->noteToDelete->delete();
//            session()->flash('message', 'یادداشت با موفقیت حذف شد.');
//        }
//        $this->confirmingNoteDeletion = false;
//    }
//
//    public function render()
//    {
//        $notes = Auth::user()->personalNotes()->with('attachments')->latest()->paginate(10);
//        return view('livewire.personal-notebook', [
//            'notes' => $notes,
//        ])->layout('layouts.app');
//    }
//}


namespace App\Livewire;

use App\Models\PersonalNote;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Livewire\Component;
use Livewire\WithPagination;

class PersonalNotebook extends Component
{
    use WithPagination;

    public ?PersonalNote $noteToDelete = null;
    public bool $confirmingNoteDeletion = false;

    public function confirmNoteDeletion(PersonalNote $note)
    {
        $this->noteToDelete = $note;
        $this->confirmingNoteDeletion = true;
    }

    public function deleteNote()
    {
        if ($this->noteToDelete) {
            // Delete all associated files from storage first
            foreach ($this->noteToDelete->attachments as $attachment) {
                Storage::disk('public')->delete($attachment->file_path);
            }
            $this->noteToDelete->delete();
            session()->flash('message', 'یادداشت با موفقیت حذف شد.');
        }
        $this->confirmingNoteDeletion = false;
    }

    public function render()
    {
        $notes = Auth::user()->personalNotes()->latest()->paginate(10);
        return view('livewire.personal-notebook', [
            'notes' => $notes,
        ])->layout('layouts.app');
    }
}

