<?php

namespace App\Livewire;

use App\Models\Project;
use Livewire\Component;
use Carbon\Carbon;

class ProjectGanttChart extends Component
{
    public Project $project;
    public array $calendarEvents = [];

    public function mount(Project $project)
    {
        $this->project = $project;
    }

    /**
     * Format tasks into the event structure required by the FullCalendar library.
     */
    public function formatTasksForCalendar()
    {
        $tasks = $this->project->tasks()->get();
        $formattedTasks = [];

        foreach ($tasks as $task) {
            if (!$task->start_date || !$task->due_date) {
                continue;
            }

            $formattedTasks[] = [
                'id'    => (string) $task->id,
                'title' => $task->title,
                'start' => $task->start_date->format('Y-m-d'),
                'end'   => $task->due_date->addDay()->format('Y-m-d'),
                'color' => $this->getTaskColor($task->status),
            ];
        }

        $this->calendarEvents = $formattedTasks;
    }

    private function getTaskColor($status): string
    {
        return match ($status) {
            'در حال انجام' => '#f59e0b',
            'انجام شده' => '#22c55e',
            default => '#3b82f6',
        };
    }

    public function render()
    {
        $this->formatTasksForCalendar();
        return view('livewire.project-gantt-chart');
    }
}
