<?php

namespace App\Livewire;

use App\Models\Project;
use Carbon\Carbon;
use Livewire\Component;

class ProjectProgressDashboard extends Component
{
    public Project $project;

    // Properties for statistics
    public int $totalTasks = 0;
    public int $completedTasks = 0;
    public int $inProgressTasks = 0;
    public int $todoTasks = 0;
    public int $completionPercentage = 0;
    public $overdueTasks;

    // Properties for the chart
    public array $chartData = [];

    public function mount(Project $project)
    {
        $this->project = $project;
        $this->calculateStats();
    }

    /**
     * Calculate all necessary statistics for the dashboard.
     */

    public function calculateStats()
    {
        $tasks = $this->project->tasks()->get();
        $this->totalTasks = $tasks->count();

        if ($this->totalTasks > 0) {
            $this->completedTasks = $tasks->where('status', 'انجام شده')->count();
            $this->inProgressTasks = $tasks->where('status', 'در حال انجام')->count();
            $this->todoTasks = $tasks->where('status', 'برای انجام')->count();

            // Calculate completion percentage
            $this->completionPercentage = round(($this->completedTasks / $this->totalTasks) * 100);

            // [FIX] Remove the unnecessary ->get() call on the collection.
            $this->overdueTasks = $tasks->where('status', '!=', 'انجام شده')
                ->where('due_date', '<', Carbon::today());

            // Prepare data for the pie chart
            $this->chartData = [
                'labels' => ['انجام شده', 'در حال انجام', 'برای انجام'],
                'data' => [$this->completedTasks, $this->inProgressTasks, $this->todoTasks],
            ];
        }
    }

    public function render()
    {
        return view('livewire.project-progress-dashboard');
    }
}
