<?php

namespace App\Livewire;

use App\Models\Project;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;

class ProjectProgressWidget extends Component
{
    public $projects;
    public $selectedProjectId;

    public function mount()
    {
        $user = Auth::user();

        $ownedProjects = $user->projectsAsOwner()->get();
        $collaboratedProjects = $user->projectsAsCollaborator()->get();
        $this->projects = $ownedProjects->merge($collaboratedProjects)->unique('id');

        if ($this->projects->isNotEmpty()) {
            $this->selectedProjectId = $this->projects->first()->id;
        }
    }

    public function render()
    {
        $selectedProject = null;
        $tasks = collect();
        $chartData = [];

        if ($this->selectedProjectId) {
            $selectedProject = Project::with(['tasks', 'tasks.assignees'])->find($this->selectedProjectId);

            if ($selectedProject) {
                $tasks = $selectedProject->tasks;
                $totalTasks = $tasks->count();

                if ($totalTasks > 0) {
                    $completedTasks = $tasks->where('status', 'انجام شده')->count();
                    $inProgressTasks = $tasks->where('status', 'در حال انجام')->count();
                    $todoTasks = $tasks->where('status', 'برای انجام')->count();

                    $chartData = [
                        'labels' => ['انجام شده', 'در حال انجام', 'برای انجام'],
                        'data' => [$completedTasks, $inProgressTasks, $todoTasks],
                    ];
                }
            }
        }

        // [KEY CHANGE] ارسال داده‌های جدید به فرانت‌اند از طریق یک رویداد
        $this->dispatch('update-progress-chart', data: $chartData);

        return view('livewire.project-progress-widget', [
            'selectedProject' => $selectedProject,
            'tasks' => $tasks,
        ]);
    }
}
