<?php

namespace App\Livewire;

use App\Models\Project;
use Livewire\Component;

class ProjectTimeline extends Component
{
    public Project $project;
    public $entries = [];

    public function mount(Project $project)
    {
        $this->project = $project;
        $this->loadEntries();
    }

    public function loadEntries()
    {
        $this->entries = $this->project
            ->labNotebookEntries()
            ->with('user')
            ->orderBy('entry_date', 'desc')
            ->get();
    }

    public function render()
    {
        return view('livewire.project-timeline');
    }
}
