<?php
//
//namespace App\Livewire;
//
//use App\Models\PurchaseRequest;
//use App\Models\Project;
//use App\Models\Supplier;
//use App\Models\SupplierResponse;
//use App\Models\SupplierResponseItem;
//use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
//use Illuminate\Support\Facades\Auth;
//use Illuminate\Support\Facades\DB;
//use Illuminate\Support\Str;
//use Livewire\Component;
//
//
//
//class PurchaseRequestManager extends Component
//{
//    use AuthorizesRequests;
//    // Properties for the "Create" modal form
//    public $confirmingPurchaseRequestAddition = false;
//    public $notes, $priority = 'normal', $project_id;
//    public $items = [];
//    public $generatedRequestCode = ''; // پراپرتی جدید برای نگهداری کد
//
//    // Properties for Edit and Delete
//    public ?PurchaseRequest $editingRequest = null;
//    public $confirmingPurchaseRequestEdit = false;
//    public $requestIdToDelete;
//    public $confirmingPurchaseRequestDeletion = false;
//// Properties for View Modal
//    public ?PurchaseRequest $viewingRequest = null;
//    public $confirmingRequestView = false;
//
//    // Properties for the new "View Responses" Modal
//    public $confirmingResponseView = false;
//    public $responsesForRequest = [];
//
//    // Properties for Assigned Supplier
//    public $assigned_supplier_id;
//    public string $supplierSearch = '';
//    public $supplierSearchResults = [];
//
//    // Properties for the new "View Shipments" Modal
//    public ?PurchaseRequest $requestWithShipments = null;
//    public $shipmentsForRequest = [];
//    public $confirmingShipmentView = false;
//
//
//    protected $rules = [
//        'notes' => 'nullable|string',
//        'priority' => 'required|in:normal,high,low',
//        'project_id' => 'nullable|exists:projects,id',
//        'assigned_supplier_id' => 'nullable|exists:suppliers,id', // قانون جدید
//        'items' => 'required|array|min:1',
//        'items.*.item_name' => 'required|string|max:255',
//        'items.*.quantity' => 'required|numeric|min:1',
//        'items.*.description' => 'nullable|string', // اعتبارسنجی برای فیلد جدید
//        'items.*.unit' => 'required|string|max:50',
//        'items.*.supplier_id' => 'nullable|exists:suppliers,id',
//    ];
//
//    /**
//     * Generate a new unique request code.
//     */
//    private function generateRequestCode()
//    {
//        do {
//            $stringPart = strtoupper(Str::random(3));
//            $numberPart = str_pad(rand(0, 9999999), 7, '0', STR_PAD_LEFT);
//            $code = "{$stringPart}-{$numberPart}";
//        } while (PurchaseRequest::where('request_code', $code)->exists());
//
//        $this->generatedRequestCode = $code;
//    }
//
//    /**
//     * Show the modal for creating a new purchase request.
//     */
//    public function confirmPurchaseRequestAddition()
//    {
//        $this->resetErrorBag();
//        $this->reset(['notes', 'priority', 'project_id', 'assigned_supplier_id', 'supplierSearch', 'supplierSearchResults']);
//        $this->items = [
//            ['item_name' => '', 'description' => '', 'quantity' => 1, 'unit' => '', 'supplier_id' => null]
//        ];
//        $this->generateRequestCode(); // تولید کد در هنگام باز شدن مودال
//        $this->confirmingPurchaseRequestAddition = true;
//    }
//
//    public function addItemRow()
//    {
//        $this->items[] = ['item_name' => '', 'description' => '', 'quantity' => 1, 'unit' => '', 'supplier_id' => null];
//    }
//
//    public function removeItemRow($index)
//    {
//        unset($this->items[$index]);
//        $this->items = array_values($this->items);
//    }
//
//    /**
//     * Save the new purchase request to the database.
//     */
//    public function saveRequest()
//    {
//        $this->validate();
//
//
//        $data = [
//            'request_code' => $this->generatedRequestCode,
//            'requester_id' => Auth::id(),
//            'institution_id' => Auth::user()->currentTeam->id,
//            'project_id' => $this->project_id,
//            'assigned_supplier_id' => $this->assigned_supplier_id, // ذخیره تامین‌کننده اختصاصی
//            'notes' => $this->notes,
//            'priority' => $this->priority,
//        ];
//
//        // --- منطق جدید گردش کار تایید ---
//        $userIsOwner = false;
//        if ($this->project_id) {
//            $project = Project::find($this->project_id);
//            if ($project && $project->owner_id === Auth::id()) {
//                $userIsOwner = true;
//            }
//            // اگر کاربر مالک نیست، درخواست برای مالک ارسال می‌شود
//            if (!$userIsOwner) {
//                $data['status'] = 'pending_approval'; // وضعیت جدید: در انتظار تایید مالک
//                $data['approver_id'] = $project->owner_id;
//            }
//        }
//
//        // اگر کاربر مالک طرح باشد یا طرحی انتخاب نشده باشد، درخواست مستقیم برای بازرگان ارسال می‌شود
//        if ($userIsOwner || !$this->project_id) {
//            $data['status'] = 'pending_merchant'; // وضعیت جدید: در انتظار بازرگان
//            $data['approved_at'] = now();
//            $data['approver_id'] = Auth::id(); // خود کاربر به عنوان تایید کننده ثبت می‌شود
//        }
//
//        $request = PurchaseRequest::create($data);
//
//        foreach ($this->items as $item) {
//            $request->items()->create($item);
//        }
//
//        $this->confirmingPurchaseRequestAddition = false;
//        session()->flash('message', 'درخواست خرید جدید با موفقیت ثبت شد.');
//    }
//
//    /**
//     * Show the modal for editing an existing purchase request.
//     */
//    public function confirmPurchaseRequestEdit(PurchaseRequest $request)
//    {
//
//        $this->authorize('update', $request);
//        $this->resetErrorBag();
//        $this->items = $request->items->map(function ($item) {
//            return [
//                'id' => $item->id,
//                'item_name' => $item->item_name,
//                'description' => $item->description,
//                'quantity' => $item->quantity,
//                'unit' => $item->unit,
//                'supplier_id' => $item->supplier_id
//            ];
//        })->toArray();
//        $this->editingRequest = $request->load('assignedSupplier');
//        $this->notes = $request->notes;
//        $this->priority = $request->priority;
//        $this->project_id = $request->project_id;
//        $this->assigned_supplier_id = $request->assigned_supplier_id;
//        $this->supplierSearch = $request->assignedSupplier?->company_name ?? '';
//        $this->supplierSearchResults = [];
//        $this->items = $request->items->toArray();
//        $this->confirmingPurchaseRequestEdit = true;
//    }
//
//    /**
//     * Update the existing purchase request.
//     */
//    public function updateRequest()
//    {
//        $this->authorize('update', $this->editingRequest);
//        $this->validate([
//            'notes' => 'nullable|string',
//            'priority' => 'required|in:normal,high,low',
//            'project_id' => 'nullable|exists:projects,id',
//            'assigned_supplier_id' => 'nullable|exists:suppliers,id',
//            'items' => 'required|array|min:1',
//            'items.*.item_name' => 'required|string|max:255',
//            'items.*.description' => 'nullable|string',
//            'items.*.quantity' => 'required|numeric|min:1',
//            'items.*.unit' => 'required|string|max:50',
//        ]);
//
//        $this->editingRequest->update([
//            'notes' => $this->notes,
//            'priority' => $this->priority,
//            'project_id' => $this->project_id,
//            'assigned_supplier_id' => $this->assigned_supplier_id,
//        ]);
//
//        // A simple way to update items is to delete the old ones and create the new ones.
//        $this->editingRequest->items()->delete();
//        foreach ($this->items as $item) {
//            $this->editingRequest->items()->create($item);
//        }
//
//        $this->confirmingPurchaseRequestEdit = false;
//        session()->flash('message', 'درخواست خرید با موفقیت به‌روزرسانی شد.');
//    }
//
//    /**
//     * Show the confirmation modal for deleting a request.
//     */
//    public function confirmPurchaseRequestDeletion($id)
//    {
//        $this->requestIdToDelete = $id;
//        $this->confirmingPurchaseRequestDeletion = true;
//    }
//
//    /**
//     * Delete the purchase request.
//     */
//    public function deleteRequest()
//    {
//        $request = PurchaseRequest::findOrFail($this->requestIdToDelete);
//        $this->authorize('delete', $request);
//
//        $request->delete();
//        $this->confirmingPurchaseRequestDeletion = false;
//        session()->flash('message', 'درخواست خرید با موفقیت حذف شد.');
//    }
//
//    /**
//     * Show the read-only modal with the full details of the request.
//     */
//    public function viewRequest(PurchaseRequest $request)
//    {
//        // We load all necessary relationships for display.
//        $this->viewingRequest = $request->load('requester', 'project', 'items.supplier');
//        $this->confirmingRequestView = true;
//    }
//
//    /**
//     * Show the modal with all supplier responses for a given request.
//     */
//    public function viewResponses(PurchaseRequest $request)
//    {
//        // --- راه حل قطعی: بارگذاری کامل و بهینه تمام روابط تودرتو ---
//        // ما ابتدا درخواست اصلی را به همراه تمام آیتم‌ها و پاسخ‌های نهایی آن‌ها بارگذاری می‌کنیم
//        $this->viewingRequest = $request->load('items.finalResponseItem.response.supplier');
//
//        // سپس، پاسخ‌های تأمین‌کنندگان را به صورت جداگانه بارگذاری می‌کنیم
//        $this->responsesForRequest = $request->responses()->with('supplier', 'items.originalItem')->get();
//
//        $this->confirmingResponseView = true;
//    }
//
//    /**
//     * [NEW] A helper method to check if all items in a request have a final response,
//     * and update the request status accordingly.
//     */
//    private function checkAndUpdateRequestStatus(PurchaseRequest $request)
//    {
//        // Reload the request to get the latest item statuses
//        $request->load('items');
//
//        // Check if there are any items still pending an offer
//        $hasPendingItems = $request->items()->where('status', 'pending_offer')->exists();
//
//        if (!$hasPendingItems) {
//            $request->update(['status' => 'final_approval']);
//        }
//    }
//
//    public function setFinalItemResponse(SupplierResponseItem $responseItem)
//    {
//
//        $responseItem->load('originalItem.purchaseRequest');
//        $purchaseRequest = $responseItem->originalItem->purchaseRequest;
//
//        if (!$purchaseRequest) {
//            session()->flash('error', 'خطا: درخواست خرید مرتبط یافت نشد.');
//            return;
//        }
//
//        $this->authorize('confirmResponses', $purchaseRequest);
//
//        $originalRequestItem = $responseItem->originalItem;
//        $originalRequestItem->update([
//            'status' => 'offer_accepted',
//            'final_supplier_response_item_id' => $responseItem->id,
//        ]);
//
//        $this->checkAndUpdateRequestStatus($purchaseRequest);
//
//        $this->viewResponses($this->viewingRequest->fresh());
//        session()->flash('message', 'پیشنهاد برای آیتم مورد نظر با موفقیت تایید شد.');
//    }
//
//    public function setFinalFullResponse(SupplierResponse $response)
//    {
//
//        $response->load('purchaseRequest');
//        if (!$response->purchaseRequest) {
//            session()->flash('error', 'خطا: درخواست خرید مرتبط یافت نشد.');
//            return;
//        }
//
//        $this->authorize('confirmResponses', $response->purchaseRequest);
//
//        DB::transaction(function () use ($response) {
//            foreach ($response->items as $responseItem) {
//                $originalRequestItem = $responseItem->originalItem;
//                if ($originalRequestItem->status === 'pending_offer') {
//                    $originalRequestItem->update([
//                        'status' => 'offer_accepted',
//                        'final_supplier_response_item_id' => $responseItem->id,
//                    ]);
//                }
//            }
//        });
//
//        $this->checkAndUpdateRequestStatus($response->purchaseRequest);
//
//        $this->viewResponses($this->viewingRequest->fresh());
//        session()->flash('message', 'تمام آیتم‌های باقی‌مانده از این پیشنهاد با موفقیت تایید نهایی شد.');
//    }
//
//
//    /**
//     * Live search for suppliers.
//     */
//    public function updatedSupplierSearch()
//    {
//        if (strlen($this->supplierSearch) < 2) {
//            $this->supplierSearchResults = [];
//            return;
//        }
//        $this->supplierSearchResults = Supplier::where('company_name', 'like', '%' . $this->supplierSearch . '%')
//            ->take(5)
//            ->get();
//    }
//
//    /**
//     * Select a supplier from the search results.
//     */
//    public function selectSupplier(Supplier $supplier)
//    {
//        $this->assigned_supplier_id = $supplier->id;
//        $this->supplierSearch = $supplier->company_name;
//        $this->supplierSearchResults = [];
//    }
//
//    /**
//     * Clear the selected supplier.
//     */
//    public function clearSelectedSupplier()
//    {
//        $this->assigned_supplier_id = null;
//        $this->supplierSearch = '';
//        $this->supplierSearchResults = [];
//    }
//
//    /**
//     * Show the modal with all shipment details for a given request.
//     */
//    public function viewShipments(PurchaseRequest $request)
//    {
//        $this->requestWithShipments = $request;
//
//        // ما تمام آیتم‌های برنده شده و ارسال شده این درخواست را پیدا می‌کنیم
//        $winningItems = $request->items()
//            ->whereNotNull('final_supplier_response_item_id')
//            ->whereHas('finalResponseItem.shipment') // فقط آیتم‌های ارسال شده
//            ->with('finalResponseItem.shipment.supplier') // <-- ما اطلاعات تامین‌کننده را نیز بارگذاری می‌کنیم
//            ->get();
//
//        // حالا آن‌ها را بر اساس بسته ارسالی، گروه‌بندی می‌کنیم
//        $this->shipmentsForRequest = $winningItems
//            ->groupBy('finalResponseItem.shipment.id')
//            ->map(function ($itemsInShipment) {
//                $shipment = $itemsInShipment->first()->finalResponseItem->shipment;
//                return [
//                    'supplier_name' => $shipment->supplier->company_name, // <-- نام تامین‌کننده اضافه شد
//                    'tracking_code' => $shipment->tracking_code,
//                    'shipping_method' => $shipment->shipping_method,
//                    'dispatched_at' => $shipment->dispatched_at,
//                    'items' => $itemsInShipment->map(function ($item) {
//                        return [
//                            'name' => $item->item_name,
//                            'quantity' => $item->finalResponseItem->supplied_quantity,
//                            'unit' => $item->unit,
//                        ];
//                    })
//                ];
//            });
//
//        $this->confirmingShipmentView = true;
//    }
//
//
//
//    public function render()
//    {
//        $user = Auth::user();
//
//        // --- کوئری جدید و هوشمند ---
//        // ما درخواست‌هایی را می‌خوانیم که:
//        // ۱. توسط کاربر فعلی ایجاد شده‌اند
//        // ۲. یا توسط کاربر فعلی (به عنوان مالک طرح) تأیید شده‌اند.
//        $requests = PurchaseRequest::query()
//            ->where(function ($query) use ($user) {
//                $query->where('requester_id', $user->id)
//                    ->orWhere('approver_id', $user->id);
//            })
//            ->with(['requester', 'project', 'approver', 'responses.supplier', 'items.finalResponseItem.shipment'])
//            ->withCount('items')
//            ->latest()
//            ->get();
//
//        $projects = Project::where('owner_id', $user->id)->orWhereHas('collaborators', function($q) use ($user) {
//            $q->where('users.id', $user->id);
//        })->get();
//
//        $suppliers = Supplier::all();
//
//        return view('livewire.purchase-request-manager', [
//            'requests' => $requests,
//            'projects' => $projects,
//            'suppliers' => $suppliers,
//        ])->layout('layouts.app');
//    }
//}


namespace App\Livewire;

use App\Models\Project;
use App\Models\PurchaseRequest;
use App\Models\Shipment;
use App\Models\Supplier;
use App\Models\SupplierResponse;
use App\Models\SupplierResponseItem;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Livewire\Component;

class PurchaseRequestManager extends Component
{
    use AuthorizesRequests;

    // Modal Properties
    public $confirmingPurchaseRequestAddition = false;
    public $confirmingPurchaseRequestEdit = false;
    public $confirmingPurchaseRequestDeletion = false;
    public $confirmingRequestView = false;
    public $confirmingResponseView = false;
    public $confirmingShipmentView = false;
    public $confirmingShipmentDelivery = false; // [NEW] For delivery confirmation modal

    // Model Properties
    public ?PurchaseRequest $editingRequest = null;
    public ?PurchaseRequest $viewingRequest = null;
    public ?PurchaseRequest $requestWithShipments = null;
    public $requestIdToDelete;
    public $shipmentToConfirmId; // [NEW] To hold the ID of the shipment to be confirmed

    // Form State Properties
    public $notes, $priority = 'normal', $project_id;
    public $items = [];
    public $generatedRequestCode = '';
    public $responsesForRequest = [];
    public $shipmentsForRequest = [];

    // Supplier Search Properties
    public $assigned_supplier_id;
    public string $supplierSearch = '';
    public $supplierSearchResults = [];

    protected $rules = [
        'notes' => 'nullable|string',
        'priority' => 'required|in:normal,high,low',
        'project_id' => 'nullable|exists:projects,id',
        'assigned_supplier_id' => 'nullable|exists:suppliers,id',
        'items' => 'required|array|min:1',
        'items.*.item_name' => 'required|string|max:255',
        'items.*.quantity' => 'required|numeric|min:1',
        'items.*.description' => 'nullable|string',
        'items.*.unit' => 'required|string|max:50',
    ];

    private function generateRequestCode()
    {
        do {
            $stringPart = strtoupper(Str::random(3));
            $numberPart = str_pad(rand(0, 9999999), 7, '0', STR_PAD_LEFT);
            $code = "{$stringPart}-{$numberPart}";
        } while (PurchaseRequest::where('request_code', $code)->exists());
        $this->generatedRequestCode = $code;
    }

    public function confirmPurchaseRequestAddition()
    {
        $this->resetErrorBag();
        $this->reset(['notes', 'priority', 'project_id', 'assigned_supplier_id', 'supplierSearch', 'supplierSearchResults']);
        $this->items = [['item_name' => '', 'description' => '', 'quantity' => 1, 'unit' => '']];
        $this->generateRequestCode();
        $this->confirmingPurchaseRequestAddition = true;
    }

    public function addItemRow()
    {
        $this->items[] = ['item_name' => '', 'description' => '', 'quantity' => 1, 'unit' => ''];
    }

    public function removeItemRow($index)
    {
        unset($this->items[$index]);
        $this->items = array_values($this->items);
    }

    public function saveRequest()
    {
        $this->validate();
        $data = [
            'request_code' => $this->generatedRequestCode,
            'requester_id' => Auth::id(),
            'institution_id' => Auth::user()->currentTeam->id,
            'project_id' => $this->project_id,
            'assigned_supplier_id' => $this->assigned_supplier_id,
            'notes' => $this->notes,
            'priority' => $this->priority,
        ];

        $userIsOwner = false;
        if ($this->project_id) {
            $project = Project::find($this->project_id);
            if ($project && $project->owner_id === Auth::id()) {
                $userIsOwner = true;
            }
            if (!$userIsOwner) {
                $data['status'] = 'pending_approval';
                $data['approver_id'] = $project->owner_id;
            }
        }

        if ($userIsOwner || !$this->project_id) {
            $data['status'] = 'pending_merchant';
            $data['approved_at'] = now();
            $data['approver_id'] = Auth::id();
        }

        $request = PurchaseRequest::create($data);
        foreach ($this->items as $item) {
            $request->items()->create($item);
        }

        $this->confirmingPurchaseRequestAddition = false;
        session()->flash('message', 'درخواست خرید جدید با موفقیت ثبت شد.');
    }

    public function confirmPurchaseRequestEdit(PurchaseRequest $request)
    {
        $this->authorize('update', $request);
        $this->resetErrorBag();
        $this->editingRequest = $request->load('assignedSupplier');
        $this->notes = $request->notes;
        $this->priority = $request->priority;
        $this->project_id = $request->project_id;
        $this->assigned_supplier_id = $request->assigned_supplier_id;
        $this->supplierSearch = $request->assignedSupplier?->company_name ?? '';
        $this->supplierSearchResults = [];
        $this->items = $request->items->toArray();
        $this->confirmingPurchaseRequestEdit = true;
    }

    public function updateRequest()
    {
        $this->authorize('update', $this->editingRequest);
        $validatedData = $this->validate([
            'notes' => 'nullable|string',
            'priority' => 'required|in:normal,high,low',
            'project_id' => 'nullable|exists:projects,id',
            'assigned_supplier_id' => 'nullable|exists:suppliers,id',
            'items' => 'required|array|min:1',
            'items.*.item_name' => 'required|string|max:255',
            'items.*.description' => 'nullable|string',
            'items.*.quantity' => 'required|numeric|min:1',
            'items.*.unit' => 'required|string|max:50',
        ]);

        $this->editingRequest->update($validatedData);
        $this->editingRequest->items()->delete();
        foreach ($this->items as $item) {
            $this->editingRequest->items()->create($item);
        }

        $this->confirmingPurchaseRequestEdit = false;
        session()->flash('message', 'درخواست خرید با موفقیت به‌روزرسانی شد.');
    }

    public function confirmPurchaseRequestDeletion($id)
    {
        $this->requestIdToDelete = $id;
        $this->confirmingPurchaseRequestDeletion = true;
    }

    public function deleteRequest()
    {
        $request = PurchaseRequest::findOrFail($this->requestIdToDelete);
        $this->authorize('delete', $request);
        $request->delete();
        $this->confirmingPurchaseRequestDeletion = false;
        session()->flash('message', 'درخواست خرید با موفقیت حذف شد.');
    }

    public function viewRequest(PurchaseRequest $request)
    {
        $this->viewingRequest = $request->load('requester', 'project', 'items.supplier');
        $this->confirmingRequestView = true;
    }

    public function viewResponses(PurchaseRequest $request)
    {
        $this->viewingRequest = $request->load('items.finalResponseItem.response.supplier');
        $this->responsesForRequest = $request->responses()->with('supplier', 'items.originalItem')->get();
        $this->confirmingResponseView = true;
    }

    private function checkAndUpdateRequestStatus(PurchaseRequest $request)
    {
        $request->load('items');
        $hasPendingItems = $request->items()->where('status', 'pending_offer')->exists();
        if (!$hasPendingItems) {
            $request->update(['status' => 'final_approval']);
        }
    }

    public function setFinalItemResponse(SupplierResponseItem $responseItem)
    {
        $responseItem->load('originalItem.purchaseRequest');
        $purchaseRequest = $responseItem->originalItem->purchaseRequest;
        $this->authorize('confirmResponses', $purchaseRequest);

        $originalRequestItem = $responseItem->originalItem;
        $originalRequestItem->update([
            'status' => 'offer_accepted',
            'final_supplier_response_item_id' => $responseItem->id,
        ]);

        $this->checkAndUpdateRequestStatus($purchaseRequest);
        $this->viewResponses($this->viewingRequest->fresh());
        session()->flash('message', 'پیشنهاد برای آیتم مورد نظر با موفقیت تایید شد.');
    }

    public function setFinalFullResponse(SupplierResponse $response)
    {
        $response->load('purchaseRequest');
        $this->authorize('confirmResponses', $response->purchaseRequest);

        DB::transaction(function () use ($response) {
            foreach ($response->items as $responseItem) {
                $originalRequestItem = $responseItem->originalItem;
                if ($originalRequestItem->status === 'pending_offer') {
                    $originalRequestItem->update([
                        'status' => 'offer_accepted',
                        'final_supplier_response_item_id' => $responseItem->id,
                    ]);
                }
            }
        });

        $this->checkAndUpdateRequestStatus($response->purchaseRequest);
        $this->viewResponses($this->viewingRequest->fresh());
        session()->flash('message', 'تمام آیتم‌های باقی‌مانده از این پیشنهاد با موفقیت تایید نهایی شد.');
    }

    public function updatedSupplierSearch()
    {
        if (strlen($this->supplierSearch) < 2) {
            $this->supplierSearchResults = [];
            return;
        }
        $this->supplierSearchResults = Supplier::where('company_name', 'like', '%' . $this->supplierSearch . '%')->take(5)->get();
    }

    public function selectSupplier(Supplier $supplier)
    {
        $this->assigned_supplier_id = $supplier->id;
        $this->supplierSearch = $supplier->company_name;
        $this->supplierSearchResults = [];
    }

    public function clearSelectedSupplier()
    {
        $this->assigned_supplier_id = null;
        $this->supplierSearch = '';
        $this->supplierSearchResults = [];
    }

    /**
     * [REWRITTEN] Show the modal with all shipment details for a given request.
     * This now works with the new pivot table structure and includes delivery status.
     */
    public function viewShipments(PurchaseRequest $request)
    {
        $this->requestWithShipments = $request->load('shipments.supplier', 'shipments.items.supplierResponseItem.originalItem');

        $this->shipmentsForRequest = $this->requestWithShipments->shipments->map(function ($shipment) {
            return [
                'id' => $shipment->id,
                'supplier_name' => $shipment->supplier->company_name,
                'tracking_code' => $shipment->tracking_code,
                'shipping_method' => $shipment->shipping_method,
                'dispatched_at' => $shipment->dispatched_at,
                'status' => $shipment->status,
                'delivered_at' => $shipment->delivered_at,
                'items' => $shipment->items->map(function ($shipmentItem) {
                    if (!$shipmentItem->supplierResponseItem || !$shipmentItem->supplierResponseItem->originalItem) {
                        return null; // Handle potential data inconsistency
                    }
                    $responseItem = $shipmentItem->supplierResponseItem;
                    $originalItem = $responseItem->originalItem;
                    return [
                        'name' => $originalItem->item_name,
                        'quantity' => $responseItem->supplied_quantity,
                        'unit' => $originalItem->unit,
                    ];
                })->filter() // Remove null items
            ];
        })->toArray();

        $this->confirmingShipmentView = true;
    }

    /**
     * [NEW] Show the confirmation modal before marking a shipment as delivered.
     */
    public function promptForDeliveryConfirmation(int $shipmentId)
    {
        $this->shipmentToConfirmId = $shipmentId;
        $this->confirmingShipmentDelivery = true;
    }

    /**
     * [NEW] Mark a shipment as delivered.
     */
    public function confirmDelivery()
    {
        if (!$this->shipmentToConfirmId) return;

        $shipment = Shipment::find($this->shipmentToConfirmId);

        if ($shipment) {
            // Optional: Add authorization check here
            // $this->authorize('receive', $shipment);

            $shipment->update([
                'status' => 'delivered',
                'delivered_at' => now(),
            ]);

            // Refresh the modal view with updated data
            $this->viewShipments($shipment->purchaseRequest);
            session()->flash('message', 'دریافت بسته با موفقیت تایید شد.');
        }

        $this->confirmingShipmentDelivery = false;
    }

    public function render()
    {
        $user = Auth::user();
        $requests = PurchaseRequest::query()
            ->where(function ($query) use ($user) {
                $query->where('requester_id', $user->id)
                    ->orWhere('approver_id', $user->id);
            })
            ->with(['requester', 'project', 'approver', 'responses.supplier', 'shipments'])
            ->withCount('items')
            ->latest()
            ->get();

        $projects = Project::where('owner_id', $user->id)->orWhereHas('collaborators', function ($q) use ($user) {
            $q->where('users.id', $user->id);
        })->get();

        return view('livewire.purchase-request-manager', [
            'requests' => $requests,
            'projects' => $projects,
        ])->layout('layouts.app');
    }
}

