<?php

namespace App\Livewire;

use App\Models\TeamAnnouncement;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;

class TeamAnnouncementsWidget extends Component
{
    public function render()
    {
        $user = Auth::user();
        // Get IDs of all teams the user is a member of
        $teamIds = $user->researchTeams()->pluck('research_teams.id');

        // Fetch pinned announcements and recent (last 7 days) announcements
        $announcements = TeamAnnouncement::whereIn('research_team_id', $teamIds)
            ->with('user', 'team')
            ->where(function ($query) {
                $query->where('is_pinned', true)
                    ->orWhere('created_at', '>=', now()->subDays(7));
            })
            ->orderByDesc('is_pinned')
            ->orderByDesc('created_at')
            ->take(5) // Limit to 5 announcements on the dashboard
            ->get();

        return view('livewire.team-announcements-widget', [
            'announcements' => $announcements
        ]);
    }
}
