<?php

namespace App\Livewire;

use App\Models\Institution;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;
use Livewire\Component;

class TeamManager extends Component
{
    use AuthorizesRequests;

    public ?Institution $institution = null;

    // Properties for the "Create Team" modal
    public $confirmingTeamCreation = false;
    public $newTeamName = '';

    public function mount()
    {


        $user = Auth::user();
        // We find the first institution where the user is an admin.
        $membership = $user->institutionMemberships()->where('role', 'admin')->first();

        if ($membership) {
            $this->institution = Institution::with('researchTeams.users')->find($membership->institution_id);
        }
    }

    /**
     * Show the modal for creating a new team.
     */
    public function confirmTeamCreation()
    {
        $this->resetErrorBag();
        $this->newTeamName = '';
        $this->confirmingTeamCreation = true;
    }

    /**
     * Create a new research team.
     */
    public function createTeam()
    {
        $this->validate([
            'newTeamName' => 'required|string|max:255',
        ]);

        // Generate a unique code for the new team
        do {
            $code = $this->institution->code . '-' . strtoupper(Str::random(4));
        } while (\App\Models\ResearchTeam::where('research_teams_code', $code)->exists());

        $this->institution->researchTeams()->create([
            'name' => $this->newTeamName,
            'research_teams_code' => $code,
        ]);

        $this->confirmingTeamCreation = false;
        $this->institution->load('researchTeams.users'); // Refresh the data
        session()->flash('message', 'تیم تحقیقاتی جدید با موفقیت ایجاد شد.');
    }

    public function render()
    {
        return view('livewire.team-manager')
            ->layout('layouts.app');
    }
}
