<?php

namespace App\Livewire;

use App\Models\Project;
use Illuminate\Support\Collection;
use Livewire\Component;

class TestComponent extends Component
{
    public ?Project $project = null;
    public Collection $tasks;
    public array $chartData = [];

    public function mount()
    {
        // پیدا کردن اولین طرحی که حداقل یک وظیفه دارد
        $this->project = Project::has('tasks')->with(['tasks', 'tasks.assignees'])->first();

        if ($this->project) {
            $this->tasks = $this->project->tasks;
            $this->calculateStats();
        } else {
            $this->tasks = collect();
        }
    }

    public function calculateStats()
    {
        $totalTasks = $this->tasks->count();
        if ($totalTasks > 0) {
            $completedTasks = $this->tasks->where('status', 'انجام شده')->count();
            $inProgressTasks = $this->tasks->where('status', 'در حال انجام')->count();
            $todoTasks = $this->tasks->where('status', 'برای انجام')->count();

            $this->chartData = [
                'labels' => ['انجام شده', 'در حال انجام', 'برای انجام'],
                'data' => [$completedTasks, $inProgressTasks, $todoTasks],
            ];
        }
    }

    public function render()
    {
        return view('livewire.test-component')
            ->layout('layouts.app'); // یا هر layout دیگری که استفاده می‌کنید
    }
}


