<?php
//
//namespace App\Livewire;
//
//use App\Models\InventoryItem;
//use App\Models\InventoryTransfer;
//use App\Models\ResearchTeam;
//use App\Models\StorageLocation;
//use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
//use Illuminate\Support\Facades\Auth;
//use Illuminate\Support\Facades\DB;
//use Illuminate\Support\Str;
//use Livewire\Component;
//use App\Notifications\TransferRejectedNotification; // کلاس جدید ما
//
//
//class TransferApprovalManager extends Component
//{
//    use AuthorizesRequests;
//
//    public ?InventoryTransfer $viewingTransfer = null;
//    public $confirmingReceipt = false;
//
//    // Form properties for the receipt modal
//    public $itemsToPlace = [];
//    public $locations = [];
//    public $locations_level_1 = [];
//    public $locations_level_2 = [];
//    public $locations_level_3 = [];
//    public $locations_level_4 = [];
//    public $locations_level_5 = [];
//    public $occupied_positions = [];
//
//
//
//    public function confirmReceipt(InventoryTransfer $transfer)
//    {
//        $this->resetErrorBag();
//        $this->viewingTransfer = $transfer->load('items.inventoryItem');
//        $destinationTeamId = $this->viewingTransfer->destination_team_id;
//
//        $this->itemsToPlace = $transfer->items->map(function ($transferItem) use ($destinationTeamId) {
//            return [
//                'original_item_id' => $transferItem->inventory_item_id,
//                'name' => $transferItem->inventoryItem->name,
//                'quantity' => $transferItem->quantity_transferred,
//                'unit' => $transferItem->inventoryItem->unit,
//                'item_type' => $transferItem->inventoryItem->item_type,
//                'location_id' => null,
//                'placement_mode' => 'auto',
//                'selected_position' => null,
//                'selected_level_1' => null,
//                'selected_level_2' => null,
//                'selected_level_3' => null,
//                'selected_level_4' => null,
//                'selected_level_5' => null,
//                // اضافه کردن locations_level_1 برای هر آیتم
//                'locations_level_1' => StorageLocation::where('research_team_id', $destinationTeamId)
//                    ->whereNull('parent_id')
//                    ->get()
//                    ->toArray(),
//                'locations_level_2' => [],
//                'locations_level_3' => [],
//                'locations_level_4' => [],
//                'locations_level_5' => [],
//                'selectedBox' => null,
//                'occupied_positions' => [],
//            ];
//        })->toArray();
//
//        $this->confirmingReceipt = true;
//    }
//
//
//    public function updatedItemsToPlace($value, $key)
//    {
//        $parts = explode('.', $key);
//        $index = $parts[0];
//        $field = $parts[1];
//
//        if (str_starts_with($field, 'selected_level_')) {
//            $level = (int) str_replace('selected_level_', '', $field);
//            $parentId = $value;
//
//            // Reset deeper levels for this item
//            for ($i = $level + 1; $i <= 5; $i++) {
//                $this->itemsToPlace[$index]['selected_level_' . $i] = null;
//                $this->itemsToPlace[$index]['locations_level_' . $i] = [];
//            }
//            $this->itemsToPlace[$index]['selectedBox'] = null;
//            $this->itemsToPlace[$index]['occupied_positions'] = [];
//
//            if ($parentId && $level < 5) {
//                $nextLevel = $level + 1;
//                $this->itemsToPlace[$index]['locations_level_' . $nextLevel] = StorageLocation::where('parent_id', $parentId)
//                    ->get()
//                    ->toArray();
//            }
//
//            if ($level >= 4 && $value) {
//                $box = StorageLocation::with('inventoryItems')->find($value);
//                if ($box && $box->rows && $box->columns) {
//                    $this->itemsToPlace[$index]['selectedBox'] = $box->toArray();
//                    $this->itemsToPlace[$index]['occupied_positions'] = $box->inventoryItems->pluck('position_in_location')->all();
//                }
//            }
//        }
//    }
//
////    private function findFirstAvailablePosition(StorageLocation $box): ?string
////    {
////        $occupied = $box->inventoryItems()->pluck('position_in_location');
////        for ($row = 0; $row < $box->rows; $row++) {
////            for ($col = 1; $col <= $box->columns; $col++) {
////                $position = chr(65 + $row) . $col;
////                if (!$occupied->contains($position)) {
////                    return $position;
////                }
////            }
////        }
////        return null; // Box is full
////    }
//
//    private function findFirstAvailablePosition(array $box): ?string
//    {
//        if (!isset($box['rows'], $box['columns'])) {
//            return null;
//        }
//
//        $occupied = $box['occupied_positions'] ?? [];
//
//        for ($row = 0; $row < $box['rows']; $row++) {
//            for ($col = 1; $col <= $box['columns']; $col++) {
//                $position = chr(65 + $row) . $col;
//                if (!in_array($position, $occupied)) {
//                    return $position;
//                }
//            }
//        }
//        return null;
//    }
//
//    public function placeAndComplete()
//    {
//        if (!$this->viewingTransfer) return;
//
//        // Validation logic needs to be carefully constructed here
//        // ...
//
//        DB::transaction(function () {
//            foreach ($this->itemsToPlace as $index => $itemData) {
//                if ($itemData['selectedBox']) {
//                    if ($itemData['placement_mode'] === 'auto') {
//                        $position = $this->findFirstAvailablePosition($itemData['selectedBox']);
//                    }
//                }
//                $locationId = $itemData['selected_level_5'] ?? $itemData['selected_level_4'] ?? $itemData['selected_level_3'] ?? $itemData['selected_level_2'] ?? $itemData['selected_level_1'];
//
//                if(!$locationId) {
//                    $this->addError("itemsToPlace.{$index}.selected_level_1", 'انتخاب مکان الزامی است.');
//                    continue;
//                }
//
//                $position = null;
//                if ($itemData['selectedBox']) {
//                    if ($itemData['placement_mode'] === 'auto') {
//                        $position = $this->findFirstAvailablePosition($itemData['selectedBox']);
//                        if (!$position) {
//                            $this->addError("itemsToPlace.{$index}.placement_mode", 'ظرفیت این محفظه پر است.');
//                            continue;
//                        }
//                    } else {
//                        if(empty($itemData['selected_position'])){
//                            $this->addError("itemsToPlace.{$index}.selected_position", 'لطفاً یک موقعیت را انتخاب کنید.');
//                            continue;
//                        }
//                        $position = $itemData['selected_position'];
//                    }
//                }
//
//                $destinationTeam = $this->viewingTransfer->destinationTeam;
//                $newSku = ($destinationTeam->research_teams_code ?? 'TEAM') . '-' . str_pad(rand(0, 999999), 6, '0', STR_PAD_LEFT);
//
//                InventoryItem::create([
//                    'name' => $itemData['name'],
//                    'sku' => $newSku,
//                    'item_type' => $itemData['item_type'],
//                    'quantity' => $itemData['quantity'],
//                    'unit' => $itemData['unit'],
//                    'research_team_id' => $this->viewingTransfer->destination_team_id,
//                    'storage_location_id' => $locationId,
//                    'position_in_location' => $position,
//                    'owner_id' => Auth::id(),
//                    'received_date' => now(),
//                ]);
//            }
//
//            if ($this->getErrorBag()->isEmpty()) {
//                $this->viewingTransfer->update(['status' => 'completed']);
//                $this->confirmingReceipt = false;
//                session()->flash('message', 'حواله با موفقیت تایید و آیتم‌ها به انبار اضافه شدند.');
//            }
//        });
//    }
//
//    /**
//     * Reject the transfer and notify the source team's admins.
//     */
//    public function rejectTransfer(InventoryTransfer $transfer)
//    {
//        DB::transaction(function () use ($transfer) {
//            // Return the quantity back to the source inventory
//            foreach ($transfer->items as $transferItem) {
//                $sourceItem = $transferItem->inventoryItem;
//                $sourceItem->increment('quantity', $transferItem->quantity_transferred);
//            }
//            // Update the transfer status to 'rejected'
//            $transfer->update(['status' => 'rejected']);
//
//            // --- منطق جدید: ارسال اعلان به مدیران تیم مبدأ ---
//            $sourceTeam = $transfer->sourceTeam()->with('users')->first();
//            $admins = $sourceTeam->users()->wherePivot('role', 'admin')->get();
//            foreach ($admins as $admin) {
//                $admin->notify(new TransferRejectedNotification($transfer));
//            }
//        });
//
//        session()->flash('message', 'حواله با موفقیت رد شد و موجودی به انبار مبدأ بازگردانده شد.');
//    }
//
//    public function render()
//    {
//        $user = Auth::user();
//        $managedTeamIds = $user->researchTeams()->wherePivot('role', 'admin')->pluck('research_teams.id');
//
//        $transfers = InventoryTransfer::whereIn('destination_team_id', $managedTeamIds)
//            ->where('status', 'pending_receipt')
//            ->with(['sourceTeam', 'creator'])
//            ->latest()
//            ->get();
//
//        return view('livewire.transfer-approval-manager', [
//            'transfers' => $transfers,
//        ])->layout('layouts.app');
//    }
//}


namespace App\Livewire;

use App\Models\InventoryItem;
use App\Models\InventoryTransfer;
use App\Models\ResearchTeam;
use App\Models\StorageLocation;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Livewire\Component;
use App\Notifications\TransferRejectedNotification;

class TransferApprovalManager extends Component
{
    use AuthorizesRequests;

    public ?InventoryTransfer $viewingTransfer = null;
    public $confirmingReceipt = false;
    public $itemsToPlace = [];

    // Properties for Placement Error Modal
    public $confirmingPlacementError = false;
    public $placementErrorMessage = '';
    public function confirmReceipt(InventoryTransfer $transfer)
    {
        $this->resetErrorBag();
        $this->viewingTransfer = $transfer->load('items.inventoryItem');
        $destinationTeamId = $this->viewingTransfer->destination_team_id;

        $this->itemsToPlace = $transfer->items->map(function ($transferItem) use ($destinationTeamId) {
            return [
                'transfer_item_id' => $transferItem->id,
                'original_item_id' => $transferItem->inventory_item_id,
                'name' => $transferItem->inventoryItem->name,
                'quantity' => $transferItem->quantity_transferred,
                'unit' => $transferItem->inventoryItem->unit,
                'item_type' => $transferItem->inventoryItem->item_type,
                'placement_mode' => 'auto',
                'status' => 'accepted', // Default status
                'selected_position' => null,
                'selected_level_1' => null,
                'selected_level_2' => null,
                'selected_level_3' => null,
                'selected_level_4' => null,
                'selected_level_5' => null,
                'locations_level_1' => StorageLocation::where('research_team_id', $destinationTeamId)
                    ->whereNull('parent_id')
                    ->get(),
                'locations_level_2' => collect([]),
                'locations_level_3' => collect([]),
                'locations_level_4' => collect([]),
                'locations_level_5' => collect([]),
                'selectedBox' => null,
                'occupied_positions' => [],
            ];
        })->toArray();

        $this->confirmingReceipt = true;
    }

    public function setItemStatus($index, $status)
    {
        if (isset($this->itemsToPlace[$index])) {
            $this->itemsToPlace[$index]['status'] = $status;
        }
    }

    public function updatedItemsToPlace($value, $key)
    {
        $parts = explode('.', $key);
        $index = $parts[0];
        $field = $parts[1];

        if (str_starts_with($field, 'selected_level_')) {
            $level = (int)str_replace('selected_level_', '', $field);
            $parentId = $value;

            // Reset deeper levels for this item
            for ($i = $level + 1; $i <= 5; $i++) {
                $this->itemsToPlace[$index]['selected_level_' . $i] = null;
                $this->itemsToPlace[$index]['locations_level_' . $i] = collect([]);
            }
            $this->itemsToPlace[$index]['selectedBox'] = null;
            $this->itemsToPlace[$index]['occupied_positions'] = [];

            if ($parentId && $level < 5) {
                $nextLevel = $level + 1;
                $this->itemsToPlace[$index]['locations_level_' . $nextLevel] = StorageLocation::where('parent_id', $parentId)->get();
            }

            if ($level >= 4 && $value) {
                $box = StorageLocation::with('inventoryItems')->find($value);
                if ($box && $box->rows && $box->columns) {
                    $this->itemsToPlace[$index]['selectedBox'] = $box;
                    $this->itemsToPlace[$index]['occupied_positions'] = $box->inventoryItems->pluck('position_in_location')->all();
                }
            }
        }
    }

    private function findFirstAvailablePosition(StorageLocation $box): ?string
    {
        $occupied = $box->inventoryItems()->pluck('position_in_location');
        for ($row = 0; $row < $box->rows; $row++) {
            for ($col = 1; $col <= $box->columns; $col++) {
                $position = chr(65 + $row) . $col;
                if (!$occupied->contains($position)) {
                    return $position;
                }
            }
        }
        return null;
    }

//    public function placeAndComplete()
//    {
//        if (!$this->viewingTransfer) return;
//
//        // --- مرحله ۱: اعتبارسنجی پیشرفته موقعیت‌ها ---
//        $itemsToCreate = [];
//        $placementErrors = [];
//
//        foreach ($this->itemsToPlace as $index => $itemData) {
//            $locationId = $itemData['selected_level_5'] ?? $itemData['selected_level_4'] ?? $itemData['selected_level_3'] ?? $itemData['selected_level_2'] ?? $itemData['selected_level_1'];
//
//            if(!$locationId) {
//                $placementErrors[] = "مکان برای آیتم '{$itemData['name']}' انتخاب نشده است.";
//                continue;
//            }
//
//            $position = null;
//            if ($itemData['selectedBox']) {
//                $box = StorageLocation::find($itemData['selectedBox']['id']);
//                if ($itemData['placement_mode'] === 'auto') {
//                    $position = $this->findFirstAvailablePosition($box);
//                    if (!$position) {
//                        $placementErrors[] = "ظرفیت محفظه '{$box->name}' برای آیتم '{$itemData['name']}' پر است.";
//                    }
//                } else { // Manual mode
//                    if (empty($itemData['selected_position'])) {
//                        $placementErrors[] = "موقعیت برای آیتم '{$itemData['name']}' در حالت دستی انتخاب نشده است.";
//                    } elseif (in_array($itemData['selected_position'], $itemData['occupied_positions'])) {
//                        $placementErrors[] = "موقعیت {$itemData['selected_position']} برای آیتم '{$itemData['name']}' قبلاً اشغال شده است.";
//                    } else {
//                        $position = $itemData['selected_position'];
//                    }
//                }
//            }
//            $itemsToCreate[$index] = array_merge($itemData, ['final_location_id' => $locationId, 'final_position' => $position]);
//        }
//
//        // اگر خطایی وجود داشت، مودال را نمایش بده و عملیات را متوقف کن
//        if (!empty($placementErrors)) {
//            $this->placementErrorMessage = implode('<br>', $placementErrors);
//            $this->confirmingPlacementError = true;
//            return;
//        }
//
//        // --- مرحله ۲: انجام تمام عملیات در یک تراکنش امن ---
//        DB::transaction(function () use ($itemsToCreate) {
//            foreach ($itemsToCreate as $itemData) {
//                $destinationTeam = $this->viewingTransfer->destinationTeam;
//                $newSku = ($destinationTeam->research_teams_code ?? 'TEAM') . '-' . str_pad(rand(0, 999999), 6, '0', STR_PAD_LEFT);
//
//                InventoryItem::create([
//                    'name' => $itemData['name'],
//                    'sku' => $newSku,
//                    'item_type' => $itemData['item_type'],
//                    'quantity' => $itemData['quantity'],
//                    'unit' => $itemData['unit'],
//                    'research_team_id' => $this->viewingTransfer->destination_team_id,
//                    'storage_location_id' => $itemData['final_location_id'],
//                    'position_in_location' => $itemData['final_position'],
//                    'owner_id' => Auth::id(),
//                    'received_date' => now(),
//                ]);
//            }
//            $this->viewingTransfer->update(['status' => 'completed']);
//        });
//
//        $this->confirmingReceipt = false;
//        session()->flash('message', 'حواله با موفقیت تایید و آیتم‌ها به انبار اضافه شدند.');
//    }

    public function placeAndComplete()
    {
        if (!$this->viewingTransfer) return;

        $placementErrors = [];
        $itemsToProcess = [];
        $anyAccepted = false;

        // --- مرحله ۱: اعتبارسنجی پیشرفته برای تمام آیتم‌ها ---
        foreach ($this->itemsToPlace as $index => $itemData) {
            if ($itemData['status'] === 'accepted') {
                $anyAccepted = true;
                $locationId = $itemData['selected_level_5'] ?? $itemData['selected_level_4'] ?? $itemData['selected_level_3'] ?? $itemData['selected_level_2'] ?? $itemData['selected_level_1'];

                if (!$locationId) {
                    $placementErrors[] = "مکان برای آیتم '{$itemData['name']}' انتخاب نشده است.";
                    continue;
                }

                $position = null;
                if ($itemData['selectedBox']) {
                    $box = StorageLocation::find($itemData['selectedBox']['id']);
                    if ($itemData['placement_mode'] === 'auto') {
                        $position = $this->findFirstAvailablePosition($box);
                        if (!$position) {
                            $placementErrors[] = "ظرفیت محفظه '{$box->name}' برای آیتم '{$itemData['name']}' پر است.";
                        }
                    } else {
                        if (empty($itemData['selected_position'])) {
                            $placementErrors[] = "موقعیت برای آیتم '{$itemData['name']}' در حالت دستی انتخاب نشده است.";
                        } elseif (in_array($itemData['selected_position'], $itemData['occupied_positions'])) {
                            $placementErrors[] = "موقعیت {$itemData['selected_position']} برای آیتم '{$itemData['name']}' قبلاً اشغال شده است.";
                        } else {
                            $position = $itemData['selected_position'];
                        }
                    }
                }
                $itemsToProcess[$index] = array_merge($itemData, ['final_location_id' => $locationId, 'final_position' => $position]);
            } else {
                $itemsToProcess[$index] = $itemData;
            }
        }

        if (!empty($placementErrors)) {
            $this->placementErrorMessage = implode('<br>', $placementErrors);
            $this->confirmingPlacementError = true;
            return;
        }

        // --- مرحله ۲: انجام تمام عملیات در یک تراکنش امن ---
        DB::transaction(function () use ($itemsToProcess, $anyAccepted) {
            foreach ($itemsToProcess as $itemData) {
                if ($itemData['status'] === 'accepted') {
                    $destinationTeam = $this->viewingTransfer->destinationTeam;
                    $newSku = ($destinationTeam->research_teams_code ?? 'TEAM') . '-' . str_pad(rand(0, 999999), 6, '0', STR_PAD_LEFT);

                    InventoryItem::create([
                        'name' => $itemData['name'],
                        'sku' => $newSku,
                        'item_type' => $itemData['item_type'],
                        'quantity' => $itemData['quantity'],
                        'unit' => $itemData['unit'],
                        'research_team_id' => $this->viewingTransfer->destination_team_id,
                        'storage_location_id' => $itemData['final_location_id'],
                        'position_in_location' => $itemData['final_position'],
                        'owner_id' => Auth::id(),
                        'received_date' => now(),
                    ]);
                } elseif ($itemData['status'] === 'rejected') {
                    $transferItem = \App\Models\InventoryTransferItem::find($itemData['transfer_item_id']);
                    if ($transferItem) {
                        $transferItem->inventoryItem->increment('quantity', $transferItem->quantity_transferred);
                    }
                }
            }

            $finalStatus = $anyAccepted ? 'completed' : 'rejected';
            $this->viewingTransfer->update(['status' => $finalStatus]);

            if ($finalStatus === 'rejected') {
                $sourceTeamAdmins = $this->viewingTransfer->sourceTeam->users()->wherePivot('role', 'admin')->get();
                foreach ($sourceTeamAdmins as $admin) {
                    $admin->notify(new TransferRejectedNotification($this->viewingTransfer));
                }
            }
        });

        $this->confirmingReceipt = false;
        session()->flash('message', 'عملیات با موفقیت انجام شد.');
    }

    public function rejectTransfer(InventoryTransfer $transfer)
    {
        DB::transaction(function () use ($transfer) {
            foreach ($transfer->items as $transferItem) {
                $sourceItem = $transferItem->inventoryItem;
                $sourceItem->increment('quantity', $transferItem->quantity_transferred);
            }
            $transfer->update(['status' => 'rejected']);
            // --- منطق جدید: ارسال اعلان به مدیران تیم مبدأ ---
            $sourceTeam = $transfer->sourceTeam()->with('users')->first();
            $admins = $sourceTeam->users()->wherePivot('role', 'admin')->get();
            foreach ($admins as $admin) {
                $admin->notify(new TransferRejectedNotification($transfer));
            }
        });

        session()->flash('message', 'حواله با موفقیت رد شد و موجودی به انبار مبدأ بازگردانده شد.');
    }

    public function render()
    {
        $user = Auth::user();
        $managedTeamIds = $user->researchTeams()
            ->wherePivot('role', 'admin')
            ->pluck('research_teams.id');

        $transfers = InventoryTransfer::whereIn('destination_team_id', $managedTeamIds)
            ->where('status', 'pending_receipt')
            ->with(['sourceTeam', 'creator'])
            ->latest()
            ->get();

        return view('livewire.transfer-approval-manager', [
            'transfers' => $transfers,
        ])->layout('layouts.app');
    }
}
