<?php

namespace App\Livewire\UserProfile;

use Illuminate\Support\Facades\Auth;
use Livewire\Component;

class MyTeams extends Component
{
    public $teams;

    /**
     * Mount the component and load the user's teams.
     */
    public function mount()
    {
        // Load the research teams the user belongs to, including their role from the pivot table.
        $this->teams = Auth::user()->researchTeams()->withPivot('role')->get();
    }

    public function render()
    {
        return view('livewire.user-profile.my-teams');
    }
}
