<?php

namespace App\Livewire;

use App\Models\LabNotebookEntryVersion;
use jblond\Diff;
use jblond\Diff\Renderer\Html\SideBySide;
use Livewire\Component;
use Livewire\Attributes\On;

class VersionComparisonModal extends Component
{
    public bool $showModal = false;
    public ?LabNotebookEntryVersion $versionA = null;
    public ?LabNotebookEntryVersion $versionB = null;

    public string $titleDiff = '';
    public string $bodyDiff = '';

    #[On('showVersionComparer')]
    public function compareVersions(array $versionIds)
    {
        if (count($versionIds) !== 2) {
            return;
        }

        // Ensure we always compare the older version (A) with the newer one (B)
        sort($versionIds);
        $this->versionA = LabNotebookEntryVersion::find($versionIds[0]);
        $this->versionB = LabNotebookEntryVersion::find($versionIds[1]);

        if (!$this->versionA || !$this->versionB) {
            return;
        }

        // Compare Title
        $titleA = explode("\n", $this->versionA->title);
        $titleB = explode("\n", $this->versionB->title);
        $titleDiff = new Diff($titleA, $titleB, []);
        $this->titleDiff = $titleDiff->render(new SideBySide);

        // Compare Body (for simplicity, we'll compare the raw HTML as text)
        $bodyA = explode("\n", strip_tags($this->versionA->body));
        $bodyB = explode("\n", strip_tags($this->versionB->body));
        $bodyDiff = new Diff($bodyA, $bodyB, []);
        $this->bodyDiff = $bodyDiff->render(new SideBySide);

        $this->showModal = true;
    }

    public function closeModal()
    {
        $this->showModal = false;
        $this->reset(['versionA', 'versionB', 'titleDiff', 'bodyDiff']);
    }

    public function render()
    {
        return view('livewire.version-comparison-modal');
    }
}
