<?php

namespace App\Livewire;

use App\Models\LabNotebookEntryVersion;
use Livewire\Component;
use Livewire\Attributes\On;

class VersionViewerModal extends Component
{
    public ?LabNotebookEntryVersion $selectedVersion = null;
    public bool $showModal = false;

    /**
     * Listen for the 'showVersionViewer' event to load a version and show the modal.
     *
     * @param int $versionId
     */
    #[On('showVersionViewer')]
    public function loadVersion($versionId)
    {
        // Load the version with its user relationship to display the user's name
        $this->selectedVersion = LabNotebookEntryVersion::with('user')->find($versionId);
        $this->showModal = true;
    }
    /**
     * [NEW] Dispatch an event to the parent component to restore the version.
     */
    public function confirmRestore()
    {
        if ($this->selectedVersion) {
            // Dispatch the event with the version ID to the parent component
            $this->dispatch('restoreVersionConfirmed', versionId: $this->selectedVersion->id);
            // Close the current modal
            $this->closeModal();
        }
    }
    /**
     * Close the modal and reset its state.
     */
    public function closeModal()
    {
        $this->showModal = false;
        $this->selectedVersion = null; // Reset for the next opening
    }

    public function render()
    {
        return view('livewire.version-viewer-modal');
    }
}
