<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ActivityRequest extends Model
{
    use HasFactory;

    protected $fillable = [
        'requester_id',
        'assignee_id',
        'lab_notebook_entry_id',
        'activity_type',
        'status',
        'completed_at',
    ];

    /**
     * Get the user who made the request.
     */
    public function requester(): BelongsTo
    {
        return $this->belongsTo(User::class, 'requester_id');
    }

    /**
     * Get the user who is assigned the activity.
     */
    public function assignee(): BelongsTo
    {
        return $this->belongsTo(User::class, 'assignee_id');
    }

    /**
     * Get the lab notebook entry that this request belongs to.
     */
    public function labNotebookEntry(): BelongsTo
    {
        return $this->belongsTo(LabNotebookEntry::class);
    }
}
