<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Attachment extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'lab_notebook_entry_id',
        'user_id', // Assuming you might add this to your migration later
        'file_name',
        'file_path',
        'file_size',
        'mime_type',
        'caption',
    ];

    /**
     * Get the lab notebook entry that the attachment belongs to.
     */
    public function labNotebookEntry(): BelongsTo
    {
        return $this->belongsTo(LabNotebookEntry::class);
    }
    /**
     * [NEW] Get the user who uploaded the attachment.
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
