<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Facades\Hash;

class Auditor extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'pin',
        'is_active',
        'research_team_id',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'pin',
    ];

    /**
     * Hash the pin automatically when setting it.
     */
    public function setPinAttribute($value)
    {
        $this->attributes['pin'] = Hash::make($value);
    }
    /**
     * [NEW] Get the research team that the auditor belongs to.
     */
    public function researchTeam(): BelongsTo
    {
        return $this->belongsTo(ResearchTeam::class);
    }
}
