<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class BiologicalSampleRequest extends Model
{
    use HasFactory;

    protected $fillable = [
        'inventory_item_id',
        'research_team_id',
        'requester_id',
        'handler_id',
        'recipient_name',
        'checkout_date',
        'expected_return_date',
        'actual_return_date',
        'status',
        'notes',
    ];

    /**
     * Get the sample (inventory item) that was requested.
     */
    public function inventoryItem(): BelongsTo
    {
        return $this->belongsTo(InventoryItem::class, 'inventory_item_id');
    }

    /**
     * Get the research team associated with this request.
     */
    public function researchTeam(): BelongsTo
    {
        return $this->belongsTo(ResearchTeam::class);
    }

    /**
     * Get the user who requested the sample.
     */
    public function requester(): BelongsTo
    {
        return $this->belongsTo(User::class, 'requester_id');
    }

    /**
     * Get the user who handled the checkout.
     */
    public function handler(): BelongsTo
    {
        return $this->belongsTo(User::class, 'handler_id');
    }
}
