<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Relations\Pivot;

class ChatMessageReadStatus extends Pivot
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'chat_message_read_status';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'chat_message_id',
        'user_id',
        'read_at',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'read_at' => 'datetime',
    ];
}
