<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Institution extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'code', // این فیلد اضافه شد
        'type',
        'address',
        'phone',
        'website',
        'contact_person_id',
    ];
    /**
     * Get the research teams for the institution.
     */
    public function researchTeams(): HasMany
    {
        return $this->hasMany(ResearchTeam::class);
    }

    public function memberships(): HasMany
    {
        return $this->hasMany(InstitutionMembership::class);
    }
}
