<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InstitutionMembership extends Model
{
    use HasFactory;

    protected $fillable = [
        'institution_id',
        'user_id',
        'role',
        'status',
    ];
    /**
     * Get the institution that this membership belongs to.
     */
    public function institution()
    {
        return $this->belongsTo(Institution::class);
    }

    /**
     * Get the user that this membership belongs to.
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}

