<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class InstitutionRequest extends Model
{
    use HasFactory;

    protected $fillable = [
        'tracking_code',
        'user_id',
        'name',
        'type',
        'address',
        'phone',
        'website',
        'personnel_count',
        'field_of_work',
        'desired_teams_count',
        'contact_person_name',
        'status',
        'contact_person_user_id',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
    public function contactPersonUser(): BelongsTo
    {
        return $this->belongsTo(User::class, 'contact_person_user_id');
    }
}

