<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class InventoryTransfer extends Model
{
    use HasFactory;

    protected $fillable = [
        'transfer_code',
        'source_team_id',
        'destination_team_id',
        'transfer_date',
        'notes',
        'created_by_user_id',
        'status',
    ];

    public function sourceTeam(): BelongsTo
    {
        return $this->belongsTo(ResearchTeam::class, 'source_team_id');
    }

    public function destinationTeam(): BelongsTo
    {
        return $this->belongsTo(ResearchTeam::class, 'destination_team_id');
    }

    public function creator(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by_user_id');
    }

    public function items(): HasMany
    {
        return $this->hasMany(InventoryTransferItem::class);
    }
}

