<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class LabNotebookComment extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'lab_notebook_entry_id',
        'parent_id',
        'body',
        'comment_anchor_id',
    ];

    /**
     * The user who created the comment.
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * The lab notebook entry this comment belongs to.
     */
    public function entry(): BelongsTo
    {
        return $this->belongsTo(LabNotebookEntry::class, 'lab_notebook_entry_id');
    }

    /**
     * The parent comment if this is a reply.
     */
    public function parent(): BelongsTo
    {
        return $this->belongsTo(LabNotebookComment::class, 'parent_id');
    }

    /**
     * The replies to this comment.
     */
    public function replies(): HasMany
    {
        return $this->hasMany(LabNotebookComment::class, 'parent_id');
    }
}
