<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class LabNotebookEntryVersion extends Model
{
    use HasFactory;

    protected $fillable = [
        'lab_notebook_entry_id',
        'user_id',
        'version',
        'sku', // فیلد جدید
        'title',
        'body',
        'entry_date',
        'materials_log', // فیلد جدید
        'attachments_log',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'materials_log' => 'array', // این خط به لاراول می‌گوید که این ستون را به صورت آرایه مدیریت کند
        'attachments_log' => 'array',
    ];

    public function entry(): BelongsTo
    {
        return $this->belongsTo(LabNotebookEntry::class, 'lab_notebook_entry_id');
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
