<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class LabNotebookSignature extends Model
{
    use HasFactory;

    // We don't need updated_at for signatures
    public const CREATED_AT = null;
    public const UPDATED_AT = null;

    protected $fillable = [
        'lab_notebook_entry_id',
        'user_id',
        'signed_at',
    ];

    protected $casts = [
        'signed_at' => 'datetime',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function entry(): BelongsTo
    {
        return $this->belongsTo(LabNotebookEntry::class, 'lab_notebook_entry_id');
    }
}

